/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.extensions.analytics;

import java.util.Collection;
import java.util.Set;
import org.apache.commons.math3.stat.descriptive.moment.Mean;
import org.apache.commons.math3.stat.descriptive.moment.StandardDeviation;

public class AnalyticsUtil {
    public static <T> long count(Collection<Set<T>> values) {
        if (values == null) {
            return 0L;
        }
        long count = 0L;
        for (Set<T> value : values) {
            count += (long)value.size();
        }
        return count;
    }

    public static <T> Double stdDev(Collection<Set<T>> values) {
        StandardDeviation stdDev = new StandardDeviation();
        if (values == null) {
            return Double.NaN;
        }
        for (Set<T> value : values) {
            stdDev.increment(value.size());
        }
        return stdDev.getResult();
    }

    public static <T> Double avg(Collection<Set<T>> values) {
        Mean mean = new Mean();
        if (values == null) {
            return Double.NaN;
        }
        for (Set<T> value : values) {
            mean.increment(value.size());
        }
        return mean.getResult();
    }
}

