/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.extensions.analytics;

import com.radiantminds.roadmap.common.data.entities.people.PlanningMode;
import com.radiantminds.roadmap.common.data.entities.people.SchedulingTeam;
import java.util.List;

class TeamStatistics {
    private final long kanbanCount;
    private final long scrumCount;

    TeamStatistics(long kanbanCount, long scrumCount) {
        this.kanbanCount = kanbanCount;
        this.scrumCount = scrumCount;
    }

    static TeamStatistics create(List<? extends SchedulingTeam> teams) {
        long kanbanCount = 0L;
        long scrumCount = 0L;
        if (teams != null) {
            for (SchedulingTeam schedulingTeam : teams) {
                if (schedulingTeam.getPlanningMode() == null) continue;
                if (schedulingTeam.getPlanningMode().equals((Object)PlanningMode.Kanban)) {
                    ++kanbanCount;
                    continue;
                }
                ++scrumCount;
            }
        }
        return new TeamStatistics(kanbanCount, scrumCount);
    }

    long getKanbanCount() {
        return this.kanbanCount;
    }

    long getScrumCount() {
        return this.scrumCount;
    }
}

