/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.extensions.workitems;

import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.entities.workitems.WorkItemExtensionLinkData;
import com.radiantminds.roadmap.common.extensions.workitems.ProgressConfiguration;
import com.radiantminds.roadmap.common.extensions.workitems.ProgressData;
import com.radiantminds.roadmap.common.extensions.workitems.StatusData;
import com.radiantminds.roadmap.common.extensions.workitems.WorkData;
import com.radiantminds.roadmap.common.extensions.workitems.WorkItemExtension;
import com.radiantminds.roadmap.common.rest.entities.workitems.RestProgress;
import com.radiantminds.roadmap.common.rest.entities.workitems.RestStatusInfo;
import com.radiantminds.roadmap.common.rest.entities.workitems.RestWorkInfo;
import com.radiantminds.roadmap.common.rest.entities.workitems.RestWorkItem;
import com.radiantminds.roadmap.common.rest.entities.workitems.links.RestWorkItemExtensionLinkResponse;
import com.radiantminds.roadmap.common.stats.MonitoredCallResult;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class WorkItemEnrichmentUtils {
    private final WorkItemExtension workItemExtension;

    public WorkItemEnrichmentUtils(WorkItemExtension workItemExtension) {
        this.workItemExtension = workItemExtension;
    }

    public MonitoredCallResult<Void> enrichItemsWithStatusAndProgress(ProgressConfiguration progressConfiguration, Map<String, RestWorkItem> itemMap) throws Exception {
        HashSet linkKeys = Sets.newHashSet();
        for (RestWorkItem workItem : itemMap.values()) {
            List<RestWorkItemExtensionLinkResponse> links = workItem.getRestExtensionLinks();
            if (links == null) continue;
            for (RestWorkItemExtensionLinkResponse link : links) {
                linkKeys.add(link.getExtensionLink());
            }
        }
        MonitoredCallResult<WorkItemExtensionLinkData> extensionLinkDataCallResult = this.workItemExtension.getExtensionLinkData(progressConfiguration, linkKeys);
        WorkItemEnrichmentUtils.extensionLinkDataEnrichtment(itemMap, extensionLinkDataCallResult.getResult());
        return extensionLinkDataCallResult.toVoid();
    }

    private static void extensionLinkDataEnrichtment(Map<String, RestWorkItem> itemMap, WorkItemExtensionLinkData extensionLinkData) {
        for (RestWorkItem restWorkItem : itemMap.values()) {
            for (RestWorkItemExtensionLinkResponse extensionLink : restWorkItem.getRestExtensionLinks()) {
                String link = extensionLink.getExtensionLink();
                StatusData statusData = extensionLinkData.getStatusData(link);
                if (statusData != null) {
                    ProgressData selfProgress;
                    extensionLink.setStatusInfo(RestStatusInfo.from(statusData));
                    ProgressData fullProgress = extensionLinkData.getFullProgress(link);
                    if (fullProgress != null) {
                        extensionLink.setFullProgress(RestProgress.from(fullProgress));
                    }
                    if ((selfProgress = extensionLinkData.getProgress(link)) != null) {
                        extensionLink.setSelfProgress(RestProgress.from(selfProgress));
                    }
                }
                extensionLink.setEstimationRatio(extensionLinkData.getEstimatedRationData(link));
                WorkData timeData = extensionLinkData.getTimeData(link);
                if (timeData == null) continue;
                extensionLink.setSelfWorkInfo(RestWorkInfo.createSelfWorkInfoFrom(timeData));
                extensionLink.setFullWorkInfo(RestWorkInfo.createFullWorkInfoFrom(timeData));
            }
        }
    }
}

