/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.handlers.sync.releases;

import com.atlassian.pocketknife.api.logging.Log;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.radiantminds.roadmap.common.data.entities.plans.IPlan;
import com.radiantminds.roadmap.common.data.entities.releases.IRelease;
import com.radiantminds.roadmap.common.data.entities.releases.IStream;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.releases.ReleaseQueryResult;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioExtensionLinkPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioReleasePersistence;
import com.radiantminds.roadmap.common.extensions.releases.ReleaseExtension;
import com.radiantminds.roadmap.common.extensions.releases.ReleaseSyncResult;
import com.radiantminds.roadmap.common.extensions.releases.VersionsBulkSyncRequest;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.common.violations.ViolationMessage;
import com.radiantminds.roadmap.common.handlers.sync.SyncOperationResult;
import com.radiantminds.roadmap.common.handlers.sync.SyncUtils;
import com.radiantminds.roadmap.common.handlers.sync.releases.DuplicateReleaseLinkDetailsProvider;
import com.radiantminds.roadmap.common.handlers.sync.releases.ReleaseSyncConfiguration;
import com.radiantminds.roadmap.common.handlers.sync.releases.ReleaseSyncServiceHandler;
import com.radiantminds.roadmap.common.handlers.sync.releases.ValidReleaseSyncRequest;
import com.radiantminds.roadmap.common.handlers.sync.releases.ValidatedReleaseSyncRequestImpl;
import com.radiantminds.roadmap.common.handlers.sync.releases.VersionsBulkSyncRequestImpl;
import com.radiantminds.roadmap.common.rest.entities.scheduling.RestSchedulingSolution;
import com.radiantminds.roadmap.common.scheduling.Calculation;
import com.radiantminds.roadmap.common.scheduling.Scheduling;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ReleaseSyncServiceHandlerImpl
implements ReleaseSyncServiceHandler {
    private static final Log LOGGER = Log.with(ReleaseSyncServiceHandlerImpl.class);
    private static final String MST_RELEASE_NOT_FOUND = "release-not-found";
    private final PortfolioReleasePersistence releasePersistence;
    private final PortfolioExtensionLinkPersistence linkPersistence;
    private final ReleaseExtension releaseExtension;
    private final Scheduling scheduling;

    ReleaseSyncServiceHandlerImpl(PortfolioReleasePersistence releasePersistence, PortfolioExtensionLinkPersistence linkPersistence, ReleaseExtension releaseExtension, Scheduling scheduling) {
        this.releasePersistence = releasePersistence;
        this.linkPersistence = linkPersistence;
        this.releaseExtension = releaseExtension;
        this.scheduling = scheduling;
    }

    @Override
    public SyncOperationResult syncReleases(EntityContext<IPlan> entityContext, ReleaseSyncConfiguration rawConfig) throws Exception {
        ValidReleaseSyncRequest config = (ValidReleaseSyncRequest)ValidatedReleaseSyncRequestImpl.validate(rawConfig).orNull();
        if (config == null) {
            LOGGER.debug("nothing to do for request configuration", new Object[0]);
            return SyncOperationResult.EMPTY;
        }
        Optional<RestSchedulingSolution> planSolution = this.tryGetPlanSolution(entityContext.getEntityId());
        List<String> releaseIds = config.getReleaseIds();
        ArrayList violationMessages = Lists.newArrayList();
        boolean releaseNotFoundWarningAdded = false;
        ReleaseQueryResult releasesInfo = this.releasePersistence.listCustomWithLinksAndStreamInfo(releaseIds);
        DuplicateReleaseLinkDetailsProvider detailsProvider = new DuplicateReleaseLinkDetailsProvider(this.releaseExtension);
        violationMessages.addAll(SyncUtils.checkForDuplicateReleaseLinks(releasesInfo.releaseMap().values(), detailsProvider));
        LinkedHashMap releaseSyncResults = Maps.newLinkedHashMap();
        for (String releaseId : releaseIds) {
            IRelease enrichedRelease = releasesInfo.releaseMap().get(releaseId);
            if (enrichedRelease == null) {
                LOGGER.debug("no release found for id %s", releaseId);
                if (releaseNotFoundWarningAdded) continue;
                violationMessages.add(new ViolationMessage.Impl("warning", MST_RELEASE_NOT_FOUND));
                releaseNotFoundWarningAdded = true;
                continue;
            }
            if (enrichedRelease.getExtensionLinks() == null || enrichedRelease.getExtensionLinks().isEmpty()) continue;
            IStream stream = this.getStreamForRelease(enrichedRelease.getId(), releasesInfo);
            VersionsBulkSyncRequest versionsBulkSyncRequest = VersionsBulkSyncRequestImpl.create(enrichedRelease, stream, config, (RestSchedulingSolution)planSolution.orNull());
            ReleaseSyncResult bulkSyncResult = this.releaseExtension.synchronizeReleaseData(versionsBulkSyncRequest);
            releaseSyncResults.put(enrichedRelease.getId(), bulkSyncResult);
        }
        return this.createResponse(releaseSyncResults, violationMessages);
    }

    private IStream getStreamForRelease(String releaseId, ReleaseQueryResult releasesInfo) {
        IStream stream = null;
        String streamId = releasesInfo.releaseToStreamNameMap().get(releaseId);
        if (streamId != null) {
            stream = releasesInfo.streamsMap().get(streamId);
        }
        return stream;
    }

    private SyncOperationResult createResponse(LinkedHashMap<String, ReleaseSyncResult> releaseSyncResults, List<ViolationMessage> globalViolations) {
        Map<String, List<ViolationMessage>> itemViolations = this.extractItemViolations(releaseSyncResults);
        ArrayList items = Lists.newArrayList(releaseSyncResults.keySet());
        SyncOperationResult.Impl result = new SyncOperationResult.Impl(globalViolations, itemViolations, items);
        return result;
    }

    private Map<String, List<ViolationMessage>> extractItemViolations(LinkedHashMap<String, ReleaseSyncResult> releaseSyncResults) {
        HashMap violationMap = Maps.newHashMap();
        for (Map.Entry<String, ReleaseSyncResult> entry : releaseSyncResults.entrySet()) {
            violationMap.put(entry.getKey(), entry.getValue().getViolationMessages());
        }
        return violationMap;
    }

    private Optional<RestSchedulingSolution> tryGetPlanSolution(String planId) {
        Calculation calculation = (Calculation)this.scheduling.getSolutionForPlan(planId).orNull();
        if (calculation == null) {
            return Optional.absent();
        }
        return Optional.fromNullable((Object)calculation.getTransferableSolution());
    }

    public static ReleaseSyncServiceHandler createInstance(PortfolioReleasePersistence releasePersistence, PortfolioExtensionLinkPersistence linkPersistence, ReleaseExtension releaseExtension, Scheduling scheduling) {
        ReleaseSyncServiceHandlerImpl instance = new ReleaseSyncServiceHandlerImpl(releasePersistence, linkPersistence, releaseExtension, scheduling);
        return instance;
    }
}

