/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.common;

import com.google.common.base.Objects;
import com.radiantminds.roadmap.common.data.entities.common.IIdentifiable;
import com.radiantminds.roadmap.common.data.persistence.VersionConflictException;
import java.lang.reflect.Array;
import java.util.List;

public class CommonServiceUtils {
    public static <TRestEntity, TEntityInterface> TRestEntity[] transferList(Class<TRestEntity> restClazz, Class<TEntityInterface> entityClazz, List<TEntityInterface> list) {
        return CommonServiceUtils.transferList(restClazz, entityClazz, list, null);
    }

    public static <TRestEntity, TEntityInterface> TRestEntity[] transferList(Class<TRestEntity> restClazz, Class<TEntityInterface> entityClazz, List<TEntityInterface> list, Object additionalParameter) {
        Object[] retVal = (Object[])Array.newInstance(restClazz, list.size());
        try {
            int i = 0;
            for (TEntityInterface item : list) {
                retVal[i] = restClazz.isInstance(item) ? item : (additionalParameter != null ? restClazz.getConstructor(entityClazz, additionalParameter.getClass()).newInstance(item, additionalParameter) : restClazz.getConstructor(entityClazz).newInstance(item));
                ++i;
            }
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException("Missing Rest-from-entity-interface constructor.", ex);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to init Rest-from-entity-interface.", ex);
        }
        return retVal;
    }

    public static <TEntityInterface extends IIdentifiable> void assertVersionIntegrity(String strVersion, TEntityInterface dbEntity) throws VersionConflictException {
        Long version;
        if (strVersion == null) {
            throw new VersionConflictException(dbEntity.getClass(), null, dbEntity.getVersion());
        }
        try {
            version = Long.parseLong(strVersion);
        }
        catch (Exception ex) {
            throw new VersionConflictException(dbEntity.getClass(), null, dbEntity.getVersion());
        }
        if (dbEntity != null && !Objects.equal((Object)version, (Object)dbEntity.getVersion())) {
            throw new VersionConflictException(dbEntity.getClass(), version, dbEntity.getVersion());
        }
    }
}

