/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.entities.scheduling;

import com.google.common.base.Function;
import com.radiantminds.roadmap.common.scheduling.retrafo.solution.ISchedulingAssignment;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;

public class RestSchedulingAssignment {
    @XmlElement
    private String initiative;
    @XmlElement
    private String epic;
    @XmlElement
    private String story;
    @XmlElement
    private String resource;
    @XmlElement
    private String skill;
    @XmlElement
    private String stage;
    @XmlElement
    private String release;
    @XmlElement
    private double workload;
    @XmlElement
    private int sprintIndex;
    @XmlElement
    private long start;
    @XmlElement
    private long end;

    private RestSchedulingAssignment() {
    }

    public RestSchedulingAssignment(String initiative, String epic, String story, String resource, String skill, String stage, String release, double workload, int sprintIndex, long start, long end) {
        this.initiative = initiative;
        this.epic = epic;
        this.story = story;
        this.resource = resource;
        this.skill = skill;
        this.stage = stage;
        this.release = release;
        this.workload = workload;
        this.sprintIndex = sprintIndex;
        this.start = start;
        this.end = end;
    }

    public boolean isRelevantForWorkItem(Set<String> workItemIds) {
        for (String workItemId : workItemIds) {
            if (!this.isRelevantForWorkItem(workItemId)) continue;
            return true;
        }
        return false;
    }

    public boolean isRelevantForWorkItem(String workItemId) {
        if (this.story != null && this.story.equals(workItemId)) {
            return true;
        }
        if (this.epic != null && this.epic.equals(workItemId)) {
            return true;
        }
        return this.initiative != null && this.initiative.equals(workItemId);
    }

    public String getResourceId() {
        return this.resource;
    }

    public static Function<ISchedulingAssignment, RestSchedulingAssignment> createFunction(final Map<String, String> initiativesPerEpic, final Map<String, String> epicPerStory, final Map<String, String> stagePerSkill) {
        return new Function<ISchedulingAssignment, RestSchedulingAssignment>(){

            public RestSchedulingAssignment apply(ISchedulingAssignment input) {
                String story = input.getWorkItemId();
                String epic = (String)epicPerStory.get(input.getWorkItemId());
                String stageId = (String)stagePerSkill.get(input.getSkillId());
                if (epic == null) {
                    epic = story;
                    story = null;
                }
                String initiative = (String)initiativesPerEpic.get(epic);
                return new RestSchedulingAssignment(initiative, epic, story, input.getResourceId(), input.getSkillId(), stageId, input.getReleaseId(), input.getWorkLoad(), input.getSprintIndex(), input.getWorkInterval().getStartMillis(), input.getWorkInterval().getEndMillis());
            }
        };
    }

    public String getReleaseId() {
        return this.release;
    }

    public String getSkillId() {
        return this.skill;
    }

    public String getStageId() {
        return this.stage;
    }

    public long getEnd() {
        return this.end;
    }

    public String getWorkItemLeafId() {
        if (this.story != null) {
            return this.story;
        }
        if (this.epic != null) {
            return this.epic;
        }
        if (this.initiative != null) {
            return this.initiative;
        }
        throw new IllegalStateException("Assignment not associated to backlog item.");
    }

    public long getStart() {
        return this.start;
    }
}

