/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.entities.scheduling;

import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.entities.plans.SchedulingConfig;
import com.radiantminds.roadmap.common.rest.entities.plans.RestWeekdayConfiguration;
import com.radiantminds.roadmap.common.rest.entities.scheduling.RestDependencyInformation;
import com.radiantminds.roadmap.common.rest.entities.scheduling.RestHierarchyInformation;
import com.radiantminds.roadmap.common.rest.entities.scheduling.RestReleaseEntry;
import com.radiantminds.roadmap.common.rest.entities.scheduling.RestSchedulingAssignment;
import com.radiantminds.roadmap.common.rest.entities.scheduling.RestSolutionInterval;
import com.radiantminds.roadmap.common.rest.entities.scheduling.RestSprintSolution;
import com.radiantminds.roadmap.common.rest.entities.scheduling.RestStageEntry;
import com.radiantminds.roadmap.common.rest.entities.scheduling.RestStreamEntry;
import com.radiantminds.roadmap.common.rest.entities.scheduling.RestTeamEntry;
import com.radiantminds.roadmap.common.rest.entities.scheduling.annotations.RestSchedulingAnnotation;
import com.radiantminds.roadmap.common.rest.entities.scheduling.cap.RestPlanCapacity;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="solution")
@XmlAccessorType(value=XmlAccessType.NONE)
public class RestSchedulingSolution {
    @XmlElement
    private Long version;
    @XmlElement
    private Boolean isReplanned;
    @XmlElement
    private Long replannedDate;
    @XmlElement
    private Long planStartTimestamp;
    @XmlElement
    private List<RestSchedulingAssignment> assignments;
    @XmlElement
    private List<RestTeamEntry> teams;
    @XmlElement
    private List<RestStageEntry> stages;
    @XmlElement
    private List<RestStreamEntry> streams;
    @XmlElement
    private List<RestSprintSolution> sprints;
    @XmlElement
    private List<RestSchedulingAnnotation> annotations;
    @XmlElement
    private RestDependencyInformation dependencyInformation;
    @XmlElement
    private RestHierarchyInformation hierachyInformation;
    @XmlElement
    private List<RestSolutionInterval> nonWorkingDays;
    @XmlElement
    Long solverCreationTime;
    @XmlElement
    Long solveTime;
    @XmlElement
    private String planningUnit;
    @XmlElement
    private RestWeekdayConfiguration weekdayConfiguration;
    @XmlElement
    private Double hoursPerDay;
    @XmlElement
    private RestPlanCapacity capacityData;

    @Deprecated
    private RestSchedulingSolution() {
    }

    protected RestSchedulingSolution(Long version, Long replannedDate, Long planStartTimestamp, SchedulingConfig planConfiguration, List<RestSchedulingAssignment> assignments, List<RestTeamEntry> teams, List<RestStreamEntry> streams, List<RestStageEntry> stages, List<RestSprintSolution> sprints, List<RestSchedulingAnnotation> annotations, RestDependencyInformation dependencyInformation, RestHierarchyInformation hierachyInformation, List<RestSolutionInterval> nonWorkingDays, RestWeekdayConfiguration weekdayConfiguration, RestPlanCapacity capacityData) {
        this.version = version;
        this.replannedDate = replannedDate;
        if (this.replannedDate != null) {
            this.isReplanned = true;
        }
        this.planStartTimestamp = planStartTimestamp;
        this.assignments = assignments;
        this.teams = teams;
        this.streams = streams;
        this.stages = stages;
        this.sprints = sprints;
        this.annotations = annotations;
        this.hoursPerDay = planConfiguration.getHoursPerDay();
        this.planningUnit = planConfiguration.getPlanningUnit();
        this.dependencyInformation = dependencyInformation;
        this.hierachyInformation = hierachyInformation;
        this.nonWorkingDays = nonWorkingDays;
        this.weekdayConfiguration = weekdayConfiguration;
        this.capacityData = capacityData;
    }

    public void setMetaData(Long solverCreationTime, Long solveTime) {
        this.solverCreationTime = solverCreationTime;
        this.solveTime = solveTime;
    }

    public boolean isValid() {
        return this.planningUnit != null;
    }

    public List<RestSchedulingAssignment> getAssignments() {
        return this.assignments;
    }

    public Long getVersion() {
        return this.version;
    }

    public RestSolutionInterval getCalculatedReleaseInterval(String releaseId) {
        if (releaseId == null || this.streams == null) {
            return null;
        }
        for (RestStreamEntry stream : this.streams) {
            for (RestReleaseEntry release : stream.getReleases()) {
                if (!releaseId.equals(release.getId())) continue;
                return release.getCalculatedInterval();
            }
        }
        return null;
    }

    public Set<String> getReleaseIdsForWorkItem(String workItemId) {
        if (workItemId == null || this.assignments == null) {
            return Sets.newHashSet();
        }
        HashSet releases = Sets.newHashSet();
        for (RestSchedulingAssignment assignment : this.assignments) {
            if (!assignment.isRelevantForWorkItem(workItemId)) continue;
            releases.add(assignment.getReleaseId());
        }
        return releases;
    }

    public Set<String> getResourceIdsForWorkItem(String workItemId) {
        if (workItemId == null || this.assignments == null) {
            return Sets.newHashSet();
        }
        HashSet resourcesForWorkItem = Sets.newHashSet();
        for (RestSchedulingAssignment assignment : this.assignments) {
            if (!assignment.isRelevantForWorkItem(workItemId)) continue;
            resourcesForWorkItem.add(assignment.getResourceId());
        }
        return resourcesForWorkItem;
    }

    public Set<String> getTeamIdsForResources(Set<String> resources) {
        if (resources == null || this.teams == null) {
            return Sets.newHashSet();
        }
        HashSet teams = Sets.newHashSet();
        for (String resourceId : resources) {
            for (RestTeamEntry team : this.teams) {
                if (!team.hasResource(resourceId)) continue;
                teams.add(team.getId());
            }
        }
        return teams;
    }

    public Set<String> getWorkItemIdsForResourceIds(Set<String> resourceIds) {
        if (resourceIds == null || this.assignments == null) {
            return Sets.newHashSet();
        }
        HashSet retVal = Sets.newHashSet();
        for (RestSchedulingAssignment assignment : this.assignments) {
            if (!resourceIds.contains(assignment.getResourceId())) continue;
            retVal.add(assignment.getWorkItemLeafId());
        }
        return retVal;
    }

    public Set<String> getWorkItemIdsForReleaseIds(List<String> releaseIds) {
        if (releaseIds == null || this.assignments == null) {
            return Sets.newHashSet();
        }
        HashSet retVal = Sets.newHashSet();
        for (RestSchedulingAssignment assignment : this.assignments) {
            if (!releaseIds.contains(assignment.getReleaseId())) continue;
            retVal.add(assignment.getWorkItemLeafId());
        }
        return retVal;
    }

    public Set<String> getWorkItemIdsForDateRange(Long fromDate, Long toDate, List<String> releaseIds, Set<String> resourceIds, List<String> stageIds) {
        List<RestSchedulingAssignment> assignments = this.getAssignments();
        if (fromDate == null && toDate == null || assignments == null || assignments.isEmpty()) {
            return null;
        }
        long fixedFromDate = fromDate != null ? fromDate : Long.MIN_VALUE;
        long fixedToDate = toDate != null ? toDate : Long.MAX_VALUE;
        HashSet matchingIds = Sets.newHashSet();
        boolean skipStageCheck = stageIds == null || stageIds.isEmpty();
        boolean skipResourceCheck = resourceIds == null || resourceIds.isEmpty();
        boolean skipReleaseCheck = releaseIds == null || releaseIds.isEmpty();
        for (RestSchedulingAssignment assignment : assignments) {
            if (fixedToDate <= assignment.getStart() || fixedFromDate >= assignment.getEnd() || !skipStageCheck && !stageIds.contains(assignment.getStageId()) || !skipResourceCheck && !resourceIds.contains(assignment.getResourceId()) || !skipReleaseCheck && !releaseIds.contains(assignment.getReleaseId())) continue;
            matchingIds.add(assignment.getWorkItemLeafId());
        }
        return matchingIds;
    }

    public Set<String> getResourceIdsForTeamIds(List<String> teamIds) {
        if (teamIds == null || this.teams == null) {
            return Sets.newHashSet();
        }
        HashSet retVal = Sets.newHashSet();
        for (RestTeamEntry team : this.teams) {
            if (!teamIds.contains(team.getId())) continue;
            retVal.addAll(team.getResourceIds());
        }
        return retVal;
    }

    public long getLength() {
        if (this.assignments == null || this.assignments.isEmpty()) {
            return 0L;
        }
        long minStart = Long.MAX_VALUE;
        long maxEnd = Long.MIN_VALUE;
        for (RestSchedulingAssignment assignment : this.assignments) {
            minStart = Math.min(minStart, assignment.getStart());
            maxEnd = Math.max(maxEnd, assignment.getEnd());
        }
        return maxEnd - minStart;
    }

    public Long getSolverCreationTime() {
        return this.solverCreationTime;
    }

    public Long getSolveTime() {
        return this.solveTime;
    }
}

