/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.entities.scheduling;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.rest.entities.scheduling.RestSprintSolution;
import com.radiantminds.roadmap.common.scheduling.retrafo.solution.IPlanSolution;
import com.radiantminds.roadmap.common.scheduling.retrafo.solution.ISprintData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;

class RestSchedulingSolutionSprintFactory {
    RestSchedulingSolutionSprintFactory() {
    }

    static List<RestSprintSolution> createSprintsForTeam(final String teamId, IPlanSolution planSolution) {
        ArrayList retVal = Lists.newArrayList();
        ArrayList sprintListForTeam = Lists.newArrayList((Iterable)Sets.filter(planSolution.getPlanStatistics().getSprintStatistics(), (Predicate)new Predicate<ISprintData>(){

            public boolean apply(@Nullable ISprintData sprintStatistics) {
                return sprintStatistics.getTeamId().equals(teamId);
            }
        }));
        Collections.sort(sprintListForTeam, new Comparator<ISprintData>(){

            @Override
            public int compare(ISprintData sprint1, ISprintData sprint2) {
                return new Integer(sprint1.getIndex()).compareTo(sprint2.getIndex());
            }
        });
        for (ISprintData sprintStatistics : sprintListForTeam) {
            RestSprintSolution sprint = RestSprintSolution.create(sprintStatistics);
            retVal.add(sprint);
        }
        return retVal;
    }
}

