/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.entities.scheduling;

import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.entities.people.IterationStartType;
import com.radiantminds.roadmap.common.rest.entities.scheduling.RestResourceEntry;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="team")
@XmlAccessorType(value=XmlAccessType.NONE)
public class RestTeamEntry {
    @XmlElement
    private String id;
    @XmlElement
    private String title;
    @XmlElement
    private String mode;
    @XmlElement
    private Integer sprintLength;
    @XmlElement
    private IterationStartType iterationStartType;
    @XmlElement
    private List<RestResourceEntry> resources;

    private RestTeamEntry() {
    }

    public RestTeamEntry(String id, String title, String mode, Integer sprintLength, IterationStartType iterationStartType, List<RestResourceEntry> resources) {
        this.id = id;
        this.title = title;
        this.mode = mode;
        this.sprintLength = sprintLength;
        this.iterationStartType = iterationStartType;
        this.resources = resources;
    }

    public boolean hasResource(String resourceId) {
        for (RestResourceEntry resource : this.resources) {
            if (!resource.getId().equals(resourceId)) continue;
            return true;
        }
        return false;
    }

    public String getId() {
        return this.id;
    }

    public Collection<String> getResourceIds() {
        if (this.resources == null) {
            return Sets.newHashSet();
        }
        HashSet retVal = Sets.newHashSet();
        for (RestResourceEntry resource : this.resources) {
            retVal.add(resource.getId());
        }
        return retVal;
    }
}

