/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.entities.scheduling.cap;

import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.rest.entities.scheduling.RestStageOrSkillId;
import com.radiantminds.roadmap.common.rest.entities.scheduling.cap.RestResourceIntervalCapacity;
import com.radiantminds.roadmap.common.scheduling.retrafo.solution.cap.ResourceSprintStatistic;
import com.radiantminds.roadmap.common.scheduling.retrafo.solution.cap.TeamSprintCapacityStatistic;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="teamIntervalData")
@XmlAccessorType(value=XmlAccessType.NONE)
public class RestTeamSprintCapacity {
    @XmlElement
    Long startMs;
    @XmlElement
    Long endMs;
    @XmlElement
    Integer index;
    @XmlElement
    List<RestStageOrSkillId> bottlenecks;
    @XmlElement
    List<RestStageOrSkillId> freeCapacities;
    @XmlElement
    Set<RestResourceIntervalCapacity> resourceCapacities;

    RestTeamSprintCapacity(long startMs, long endMs, int index, List<RestStageOrSkillId> bottlenecks, List<RestStageOrSkillId> freeCapacities, Set<RestResourceIntervalCapacity> resourceCapacities) {
        this.index = index;
        this.startMs = startMs;
        this.endMs = endMs;
        this.bottlenecks = bottlenecks;
        this.freeCapacities = freeCapacities;
        this.resourceCapacities = resourceCapacities;
    }

    private RestTeamSprintCapacity() {
    }

    static RestTeamSprintCapacity create(TeamSprintCapacityStatistic statistic) {
        return new RestTeamSprintCapacity(statistic.getStartMs(), statistic.getEndMs(), statistic.getIndex(), RestStageOrSkillId.create(statistic.getBottleneckTypes()), RestStageOrSkillId.create(statistic.getFreeCapacities()), RestTeamSprintCapacity.createResourceStatistics(statistic.getResourceSprintCapacityStatistics()));
    }

    private static Set<RestResourceIntervalCapacity> createResourceStatistics(Set<ResourceSprintStatistic> statistics) {
        HashSet restStatistics = Sets.newHashSet();
        for (ResourceSprintStatistic statistic : statistics) {
            restStatistics.add(RestResourceIntervalCapacity.create(statistic));
        }
        return restStatistics;
    }
}

