/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.entities.workitems;

import com.radiantminds.roadmap.common.data.entities.plans.IPlan;
import com.radiantminds.roadmap.common.data.entities.workitems.IEstimate;
import com.radiantminds.roadmap.common.data.entities.workitems.IWorkItem;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="estimate")
@XmlAccessorType(value=XmlAccessType.NONE)
public class RestEstimate
implements IEstimate {
    private String id;
    @XmlElement
    private Double value;
    @XmlElement
    private Long version;
    @XmlElement
    private Integer currency;
    @XmlElement
    private Integer targetId;
    private String targetType;
    private Boolean replanning;
    private Boolean original;
    private IWorkItem workItem;

    @Deprecated
    protected RestEstimate() {
    }

    public RestEstimate(String id) {
        this.id = id;
    }

    public RestEstimate(Double value) {
        this.value = value;
    }

    public RestEstimate(Integer targetId, Double value) {
        this.targetId = targetId;
        this.value = value;
    }

    public RestEstimate(IEstimate estimate) {
        this(estimate.getId());
        this.value = estimate.getEstimate();
        this.version = this.getParentVersion();
        this.currency = estimate.getCurrency();
        this.workItem = estimate.getWorkItem();
        this.replanning = estimate.getReplanning();
        this.original = estimate.getOriginal();
        this.targetId = estimate.getTargetId();
        this.targetType = estimate.getTargetType();
    }

    private Long getParentVersion() {
        if (this.workItem != null) {
            return this.workItem.getVersion();
        }
        return null;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public Double getEstimate() {
        return this.value;
    }

    @Override
    public void setEstimate(Double value) {
        this.value = value;
    }

    @Override
    public Long getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(Long version) {
        this.version = version;
    }

    public List<IPlan> getParentPlans() {
        throw new RuntimeException("getParentPlans() is not allowed on non-db entity implementations (REST).");
    }

    @Override
    public Integer getCurrency() {
        return this.currency;
    }

    @Override
    public void setCurrency(Integer currency) {
        this.currency = currency;
    }

    @Override
    public String getTargetType() {
        return this.targetType;
    }

    @Override
    public void setTargetType(String type) {
        this.targetType = type;
    }

    @Override
    public Integer getTargetId() {
        return this.targetId;
    }

    @Override
    public void setTargetId(Integer id) {
        this.targetId = id;
    }

    @Override
    public Boolean getReplanning() {
        return this.replanning;
    }

    @Override
    public void setReplanning(Boolean replanning) {
        this.replanning = replanning;
    }

    @Override
    public Boolean getOriginal() {
        return this.original;
    }

    @Override
    public void setOriginal(Boolean original) {
        this.original = original;
    }

    @Override
    public IWorkItem getWorkItem() {
        return this.workItem;
    }

    @Override
    public void setWorkItem(IWorkItem workItem) {
        this.workItem = workItem;
    }
}

