/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services;

import com.radiantminds.roadmap.common.rest.common.ResponseBuilder;
import com.radiantminds.roadmap.common.rest.entities.async.RestLongRunningTaskState;
import com.radiantminds.roadmap.common.rest.utils.async.LongRunningService;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Consumes(value={"application/json"})
@Produces(value={"application/json", "application/xml"})
@Path(value="/async")
public class AsyncTaskService {
    @GET
    @Path(value="progress/{serviceId}")
    public Response getTaskStatus(@PathParam(value="serviceId") String serviceId) throws Throwable {
        RestLongRunningTaskState state = new RestLongRunningTaskState(LongRunningService.getState(serviceId), LongRunningService.getTaskState(serviceId));
        return ResponseBuilder.ok(state);
    }

    @GET
    @Path(value="result/{serviceId}")
    public Response getTaskResult(@PathParam(value="serviceId") String serviceId) throws Throwable {
        if (LongRunningService.getState(serviceId) != LongRunningService.State.DONE) {
            return ResponseBuilder.badRequest();
        }
        return LongRunningService.fetch(serviceId);
    }
}

