/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.customwording;

import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioCustomWordingPersistence;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPluginAdminAccess;
import com.radiantminds.roadmap.common.rest.common.ResponseBuilder;
import com.radiantminds.roadmap.common.rest.entities.configuration.RestCustomWording;
import javax.ws.rs.core.Response;

public interface CustomWordingServiceHandler {
    @AuthorizedPluginAdminAccess
    public Response store(RestCustomWording var1) throws Exception;

    @AuthorizedPluginAdminAccess
    public Response delete(String var1) throws Exception;

    public static class Impl
    implements CustomWordingServiceHandler {
        private final PortfolioCustomWordingPersistence customWordingPersistence;

        public Impl(PortfolioCustomWordingPersistence customWordingPersistence) {
            this.customWordingPersistence = customWordingPersistence;
        }

        @Override
        public Response store(RestCustomWording wording) throws Exception {
            if (wording.getWordKey() == null || wording.getWordValue() == null) {
                return ResponseBuilder.badRequest();
            }
            this.customWordingPersistence.store(wording.getWordKey(), wording.getWordValue());
            return ResponseBuilder.noContent();
        }

        @Override
        public Response delete(String key) throws Exception {
            if (key == null) {
                return ResponseBuilder.badRequest();
            }
            this.customWordingPersistence.remove(key);
            return ResponseBuilder.noContent();
        }
    }
}

