/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.errorreporting;

import com.google.common.base.Optional;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.persistence.ao.port.XmlExportablePersistenceIndex;
import com.radiantminds.roadmap.common.data.persistence.services.PortfolioPlanPersistence;
import com.radiantminds.roadmap.common.extensions.communication.CommunicationExtension;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.SecuredInvocationHandlerFactory;
import com.radiantminds.roadmap.common.rest.entities.errorreporting.RestErrorReport;
import com.radiantminds.roadmap.common.rest.services.errorreporting.ErrorReportingServiceHandler;
import com.radiantminds.roadmap.common.utils.meta.MetaDataUtils;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Consumes(value={"application/json"})
@Produces(value={"application/json", "application/xml"})
@Path(value="/errorreporting")
@Component
public class ErrorReportingService {
    private final ErrorReportingServiceHandler handler;

    @Autowired
    public ErrorReportingService(XmlExportablePersistenceIndex index, SecuredInvocationHandlerFactory handlerFactory, ActiveObjectsUtilities activeObjectsUtilities, PortfolioPlanPersistence planPersistence, CommunicationExtension communicationExtension, MetaDataUtils metaDataUtils) {
        this.handler = handlerFactory.createProxy(ErrorReportingServiceHandler.class, new ErrorReportingServiceHandler.Impl(index, activeObjectsUtilities, communicationExtension, metaDataUtils), planPersistence);
    }

    @POST
    public Response reportError(@QueryParam(value="includePlan") Boolean includePlan, RestErrorReport report) throws Exception {
        if (report.getPlanId() != null) {
            return this.handler.reportErrorForPlan(EntityContext.from(report.getPlanId()), (Boolean)Optional.fromNullable((Object)includePlan).or((Object)false), report);
        }
        return this.handler.reportError(report);
    }
}

