/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.persons;

import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioPersonPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.data.persistence.services.PortfolioPlanPersistence;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.SecuredInvocationHandlerFactory;
import com.radiantminds.roadmap.common.rest.entities.people.RestPerson;
import com.radiantminds.roadmap.common.rest.services.persons.PlanPersonServiceHandler;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Consumes(value={"application/json"})
@Produces(value={"application/json", "application/xml"})
@Path(value="/plans/{id}/persons")
@Component
public class PlanPersonService {
    private final PlanPersonServiceHandler handler;

    @Autowired
    public PlanPersonService(SecuredInvocationHandlerFactory handlerFactory, ActiveObjectsUtilities activeObjectsUtilities, PortfolioPlanPersistence planPersistence, PortfolioPersonPersistence personPersistence, PortfolioWorkItemPersistence workItemPersistence) {
        this.handler = handlerFactory.createProxy(PlanPersonServiceHandler.class, new PlanPersonServiceHandler.Impl(activeObjectsUtilities, personPersistence, workItemPersistence), planPersistence);
    }

    @GET
    public Response getAllPersons(@PathParam(value="id") String planId, @QueryParam(value="planVersion") Long expectedPlanVersion) throws Exception {
        return this.handler.getAllPersons(EntityContext.from(planId, expectedPlanVersion));
    }

    @POST
    public Response addPersonToPlan(@PathParam(value="id") String planId, @QueryParam(value="planVersion") Long expectedPlanVersion, @QueryParam(value="clientId") String clientId, RestPerson newPerson) throws Exception {
        return this.handler.addPersonToPlan(EntityContext.from(planId, expectedPlanVersion, clientId), newPerson);
    }
}

