/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.releases;

import com.radiantminds.roadmap.common.data.entities.releases.IRelease;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioReleasePersistence;
import com.radiantminds.roadmap.common.handlers.SecuredInvocationHandlerFactory;
import com.radiantminds.roadmap.common.rest.entities.releases.RestRelease;
import com.radiantminds.roadmap.common.rest.services.common.BaseOperationsService;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="/releases")
@Component
public class ReleaseService
extends BaseOperationsService<IRelease, RestRelease> {
    @Autowired
    public ReleaseService(SecuredInvocationHandlerFactory handlerFactory, PortfolioReleasePersistence releasePersistence) {
        super(RestRelease.class, releasePersistence, handlerFactory);
    }

    @Override
    protected RestRelease transform(IRelease entity, boolean includeReplanningData) {
        return new RestRelease(entity);
    }

    @Override
    protected Response update(RestRelease source, IRelease target, boolean allowNull) {
        if (allowNull || source.getDetails() != null) {
            target.setDetails(source.getDetails());
        }
        if (allowNull || source.getTitle() != null) {
            target.setTitle(source.getTitle());
        }
        if (allowNull || source.getPrimaryVersion() != null) {
            target.setPrimaryVersion(source.getPrimaryVersion());
        }
        if (allowNull || source.getFixedStartDate().isPresent()) {
            target.setFixedStartDate((Long)source.getFixedStartDate().orNull());
            if (source.getFixedStartDate().isPresent()) {
                target.setDeltaStartDate(null);
            }
        }
        if (allowNull || source.getDeltaStartDate().isPresent()) {
            target.setDeltaStartDate((Long)source.getDeltaStartDate().orNull());
            if (source.getDeltaStartDate().isPresent()) {
                target.setFixedStartDate(null);
            }
        }
        if (source.getAsEarlyAsPossible().isPresent() && ((Boolean)source.getAsEarlyAsPossible().get()).booleanValue()) {
            target.setFixedStartDate(null);
            target.setDeltaStartDate(null);
        }
        if (allowNull || source.getFixedEndDate().isPresent()) {
            Long val = (Long)source.getFixedEndDate().orNull();
            if (val == null || val == -1L) {
                val = null;
            }
            target.setFixedEndDate(val);
        }
        return null;
    }
}

