/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.replanning;

import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioEstimatePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioReleasePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioTeamPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.data.persistence.services.PortfolioPlanPersistence;
import com.radiantminds.roadmap.common.extensions.analytics.AnalyticsExtension;
import com.radiantminds.roadmap.common.extensions.issues.PortfolioToJiraSyncExtension;
import com.radiantminds.roadmap.common.extensions.workitems.WorkItemExtension;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.SecuredInvocationHandlerFactory;
import com.radiantminds.roadmap.common.rest.services.replanning.ReplanningServiceHandler;
import com.radiantminds.roadmap.common.scheduling.Scheduling;
import com.radiantminds.roadmap.common.scheduling.entities.SchedulingPlanFactory;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Consumes(value={"application/json"})
@Produces(value={"application/json", "application/xml"})
@Path(value="/replanning")
@Component
public class ReplanningService {
    private final ReplanningServiceHandler handler;

    @Autowired
    public ReplanningService(SecuredInvocationHandlerFactory handlerFactory, SchedulingPlanFactory schedulingPlanFactory, ActiveObjectsUtilities activeObjectsUtilities, PortfolioPlanPersistence planPersistence, PortfolioWorkItemPersistence workItemPersistence, PortfolioEstimatePersistence estimatePersistence, PortfolioTeamPersistence teamPersistence, PortfolioReleasePersistence releasePersistence, AnalyticsExtension analyticsExtension, WorkItemExtension workItemExtension, PortfolioToJiraSyncExtension portfolioToJiraSyncExtension, Scheduling scheduling) {
        this.handler = handlerFactory.createProxy(ReplanningServiceHandler.class, new ReplanningServiceHandler.Impl(activeObjectsUtilities, analyticsExtension, planPersistence, workItemPersistence, estimatePersistence, teamPersistence, releasePersistence, schedulingPlanFactory, workItemExtension, portfolioToJiraSyncExtension, scheduling), planPersistence);
    }

    @POST
    @Path(value="{id}/initiate")
    public Response initiateReplanning(@PathParam(value="id") String planId, @QueryParam(value="date") Long date) throws Exception {
        return this.handler.initiateReplanning(EntityContext.from(planId), date);
    }

    @POST
    @Path(value="{id}/finalize")
    public Response finalizeReplanning(@PathParam(value="id") String planId, @QueryParam(value="version") Long replanningVersion) throws Exception {
        return this.handler.finalizeReplanning(EntityContext.from(planId), replanningVersion);
    }

    @POST
    @Path(value="{id}/cancel")
    public Response cancelReplanning(@PathParam(value="id") String planId, @QueryParam(value="version") Long replanningVersion) throws Exception {
        return this.handler.cancelReplanning(EntityContext.from(planId), replanningVersion);
    }
}

