/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.scheduling;

import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.persistence.services.PortfolioPlanPersistence;
import com.radiantminds.roadmap.common.extensions.features.FeatureExtension;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.SecuredInvocationHandlerFactory;
import com.radiantminds.roadmap.common.rest.services.scheduling.SchedulingServiceHandler;
import com.radiantminds.roadmap.common.scheduling.Scheduling;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Consumes(value={"application/json"})
@Produces(value={"application/json", "application/xml"})
@Path(value="/scheduling")
@Component
public class SchedulingService {
    private final SchedulingServiceHandler handler;

    @Autowired
    public SchedulingService(SecuredInvocationHandlerFactory handlerFactory, ActiveObjectsUtilities activeObjectsUtilities, FeatureExtension featureExtension, PortfolioPlanPersistence planPersistence, Scheduling scheduling) {
        this.handler = handlerFactory.createProxy(SchedulingServiceHandler.class, new SchedulingServiceHandler.Impl(activeObjectsUtilities, featureExtension, scheduling), planPersistence);
    }

    @POST
    @Path(value="{id}")
    public Response triggerScheduling(@PathParam(value="id") String planId) throws Exception {
        return this.handler.triggerScheduling(EntityContext.from(planId));
    }

    @POST
    @Path(value="{id}/cancel")
    public Response cancelScheduling(@PathParam(value="id") String planId) throws Exception {
        return this.handler.cancelScheduling(EntityContext.from(planId));
    }

    @GET
    @Path(value="{id}/state")
    public Response getSolutionState(@PathParam(value="id") String planId) throws Exception {
        return this.handler.getSolutionState(EntityContext.from(planId));
    }
}

