/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.skills;

import com.radiantminds.roadmap.common.data.entities.skills.ISkill;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioSkillPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioStagePersistence;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.SecuredInvocationHandlerFactory;
import com.radiantminds.roadmap.common.rest.entities.common.RestPercentage;
import com.radiantminds.roadmap.common.rest.entities.skills.RestSkill;
import com.radiantminds.roadmap.common.rest.services.common.BaseOperationsService;
import com.radiantminds.roadmap.common.rest.services.skills.SkillServiceHandler;
import javax.ws.rs.DELETE;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="/skills")
@Component
public class SkillService
extends BaseOperationsService<ISkill, RestSkill> {
    private final SkillServiceHandler handler;

    @Autowired
    public SkillService(SecuredInvocationHandlerFactory handlerFactory, PortfolioStagePersistence stagePersistence, PortfolioSkillPersistence skillPersistence) {
        super(RestSkill.class, skillPersistence, handlerFactory);
        this.handler = handlerFactory.createProxy(SkillServiceHandler.class, new SkillServiceHandler.Impl(skillPersistence, stagePersistence), skillPersistence);
    }

    @Override
    protected RestSkill transform(ISkill entity, boolean includeReplanningData) {
        return new RestSkill(entity);
    }

    @Override
    protected Response update(RestSkill source, ISkill target, boolean allowNull) {
        return this.updateCommons(source, target, allowNull);
    }

    @Override
    @DELETE
    @Path(value="{id}")
    public Response entryDelete(@PathParam(value="id") String id, @QueryParam(value="version") Long version, @QueryParam(value="planVersion") Long expectedPlanVersion, @QueryParam(value="clientId") String clientId) throws Exception {
        return this.handler.entryDelete(EntityContext.from(id, version, expectedPlanVersion, clientId));
    }

    @PUT
    @Path(value="{id}/percentage")
    public Response setPercentage(@PathParam(value="id") String id, @QueryParam(value="planVersion") Long expectedPlanVersion, @QueryParam(value="clientId") String clientId, RestPercentage value) throws Exception {
        return this.handler.setPercentage(EntityContext.from(id, expectedPlanVersion, clientId), value.getValue());
    }
}

