/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.themes;

import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioThemePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.data.persistence.services.PortfolioPlanPersistence;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.SecuredInvocationHandlerFactory;
import com.radiantminds.roadmap.common.rest.entities.common.RestRank;
import com.radiantminds.roadmap.common.rest.entities.themes.RestTheme;
import com.radiantminds.roadmap.common.rest.services.themes.PlanThemeServiceHandler;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Consumes(value={"application/json"})
@Produces(value={"application/json", "application/xml"})
@Path(value="/plans/{id}/themes")
@Component
public class PlanThemeService {
    private final PlanThemeServiceHandler handler;

    @Autowired
    public PlanThemeService(SecuredInvocationHandlerFactory handlerFactory, ActiveObjectsUtilities activeObjectsUtilities, PortfolioPlanPersistence planPersistence, PortfolioWorkItemPersistence workItemPersistence, PortfolioThemePersistence themePersistence) {
        this.handler = handlerFactory.createProxy(PlanThemeServiceHandler.class, new PlanThemeServiceHandler.Impl(activeObjectsUtilities, themePersistence, workItemPersistence), planPersistence);
    }

    @GET
    public Response getAllThemes(@PathParam(value="id") String planId, @QueryParam(value="planVersion") Long expectedPlanVersion) throws Exception {
        return this.handler.getAllThemes(EntityContext.from(planId, expectedPlanVersion));
    }

    @POST
    public Response addThemeToPlan(@PathParam(value="id") String planId, @QueryParam(value="planVersion") Long expectedPlanVersion, @QueryParam(value="clientId") String clientId, RestTheme newTheme) throws Exception {
        return this.handler.addThemeToPlan(EntityContext.from(planId, expectedPlanVersion, clientId), newTheme);
    }

    @PUT
    @Path(value="/rank")
    public Response rankTheme(@PathParam(value="id") String planId, @QueryParam(value="planVersion") Long expectedPlanVersion, @QueryParam(value="clientId") String clientId, RestRank rank) throws Exception {
        return this.handler.rankTheme(EntityContext.from(planId, expectedPlanVersion, clientId), rank);
    }
}

