/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.workitems;

import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.common.DataMode;
import com.radiantminds.roadmap.common.data.entities.common.IExtensionLink;
import com.radiantminds.roadmap.common.data.entities.workitems.IEstimate;
import com.radiantminds.roadmap.common.data.entities.workitems.IEstimateBlock;
import com.radiantminds.roadmap.common.data.entities.workitems.IWorkItem;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.AOWorkItem;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioEstimatePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioExtensionLinkPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.rest.entities.workitems.RestWorkItem;
import com.radiantminds.roadmap.common.rest.services.workitems.constraints.WorkItemConstraintChecker;

public class WorkItemUtils {
    private final PortfolioWorkItemPersistence workItemPersistence;
    private final PortfolioEstimatePersistence estimatePersistence;
    private final PortfolioExtensionLinkPersistence extensionLinkPersistence;

    public WorkItemUtils(PortfolioWorkItemPersistence workItemPersistence, PortfolioEstimatePersistence estimatePersistence, PortfolioExtensionLinkPersistence extensionLinkPersistence) {
        this.workItemPersistence = workItemPersistence;
        this.estimatePersistence = estimatePersistence;
        this.extensionLinkPersistence = extensionLinkPersistence;
    }

    public void onAfterPostPersisting(RestWorkItem entity, IWorkItem persisted) throws Exception {
        String id = persisted.getId();
        this.onAfterEstimablePostPersisting(entity, id);
        this.onAfterWorkItemPostPersisting(entity, persisted);
    }

    private void onAfterEstimablePostPersisting(RestWorkItem entity, String id) throws Exception {
        if (!WorkItemConstraintChecker.isTypeAssignable(entity.getType())) {
            return;
        }
        this.setEstimates(id, entity.getCurrentEstimates(), DataMode.Default);
        if (entity.getHasOriginalEstimates().booleanValue()) {
            this.setEstimates(id, entity.getOriginalEstimates(), DataMode.Original);
        }
    }

    private void setEstimates(String id, IEstimateBlock block, DataMode dataMode) throws Exception {
        if (block.getTotal().isPresent()) {
            this.estimatePersistence.setTotalEstimate(id, (IEstimate)block.getTotal().get(), dataMode);
        }
        for (IEstimate stageEstimate : block.getStages()) {
            this.estimatePersistence.setStageEstimate(id, String.valueOf(stageEstimate.getTargetId()), stageEstimate, dataMode);
        }
        for (IEstimate skilLEstimate : block.getSkills()) {
            this.estimatePersistence.setSkillEstimate(id, String.valueOf(skilLEstimate.getTargetId()), skilLEstimate, dataMode);
        }
    }

    private void onAfterWorkItemPostPersisting(RestWorkItem entity, IWorkItem persisted) throws Exception {
        if (entity.getExtensionLinks() != null && entity.getExtensionLinks().size() > 0) {
            for (IExtensionLink link : entity.getExtensionLinks()) {
                this.extensionLinkPersistence.addExtensionLink(AOWorkItem.class, persisted.getId(), link.getExtensionKey(), link.getExtensionLink());
            }
        }
        if (entity.getStreamId() != null) {
            this.workItemPersistence.setStream(persisted.getId(), entity.getStreamId());
            if (WorkItemConstraintChecker.isTypeAssignable(persisted.getType()) && entity.getReleaseId() != null) {
                this.workItemPersistence.setRelease(persisted.getId(), entity.getReleaseId());
            }
        }
        if (entity.getThemeId().isPresent()) {
            this.workItemPersistence.setTheme(persisted.getId(), (String)entity.getThemeId().get());
        }
        if (!WorkItemConstraintChecker.isTypeAssignable(persisted.getType())) {
            return;
        }
        if (entity.getTeamId().isPresent()) {
            this.workItemPersistence.setTeamSprintResourceAssignment(persisted.getId(), (String)entity.getTeamId().get(), (String)entity.getSprintId().orNull(), Lists.newArrayList(entity.getResources()), false);
        }
    }
}

