/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.workitems.move;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.radiantminds.roadmap.common.rest.entities.common.RestRank;
import com.radiantminds.roadmap.common.rest.services.workitems.move.RestMoveAndRankRequest;
import com.radiantminds.roadmap.common.rest.services.workitems.move.WorkItemMoveRequest;
import java.util.Set;
import javax.annotation.Nullable;

class MoveRequestWrapper
implements WorkItemMoveRequest {
    private final String newParentId;
    private final RestRank rank;
    private final Set<String> inheritanceRestriction;

    MoveRequestWrapper(String newParentId, @Nullable RestRank rank, @Nullable Set<String> inheritanceRestriction) {
        Preconditions.checkNotNull((Object)newParentId);
        this.newParentId = newParentId;
        this.rank = rank;
        this.inheritanceRestriction = inheritanceRestriction;
    }

    @Override
    public String getNewParentId() {
        return this.newParentId;
    }

    @Override
    public Optional<RestRank> getRank() {
        return Optional.fromNullable((Object)this.rank);
    }

    @Override
    public Optional<Set<String>> getInheritanceRestriction() {
        return Optional.fromNullable(this.inheritanceRestriction);
    }

    static WorkItemMoveRequest create(String newParentId, RestMoveAndRankRequest request) {
        return new MoveRequestWrapper(newParentId, (RestRank)request.getRank().orNull(), (Set)request.getInheritanceRestriction().orNull());
    }
}

