/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.workitems.move;

import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.PortfolioMoveWorkItemPersistency;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.extensions.issues.PortfolioToJiraSyncExtension;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.SecuredInvocationHandlerFactory;
import com.radiantminds.roadmap.common.rest.services.workitems.move.MoveRequestWrapper;
import com.radiantminds.roadmap.common.rest.services.workitems.move.RestMoveAndRankRequest;
import com.radiantminds.roadmap.common.rest.services.workitems.move.WorkItemMoveRequest;
import com.radiantminds.roadmap.common.rest.services.workitems.move.WorkItemMoveServiceHandler;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Consumes(value={"application/json"})
@Produces(value={"application/json", "application/xml"})
@Path(value="/workitems/{id}/move")
@Component
public final class WorkItemMoveService {
    private final WorkItemMoveServiceHandler handler;

    @Autowired
    public WorkItemMoveService(SecuredInvocationHandlerFactory handlerFactory, PortfolioWorkItemPersistence workItemPersistence, PortfolioMoveWorkItemPersistency moveWorkItemPersistency, PortfolioToJiraSyncExtension portfolioToJiraSyncExtension) {
        this.handler = handlerFactory.createProxy(WorkItemMoveServiceHandler.class, new WorkItemMoveServiceHandler.Impl(workItemPersistence, moveWorkItemPersistency), workItemPersistence);
    }

    @POST
    @Path(value="/rank")
    public Response moveToAndRank(@PathParam(value="id") String workItemId, @QueryParam(value="version") Long version, @QueryParam(value="planVersion") Long expectedPlanVersion, @QueryParam(value="to") String newParentId, @QueryParam(value="clientId") String clientId, RestMoveAndRankRequest request) throws Exception {
        WorkItemMoveRequest moveRequest = MoveRequestWrapper.create(newParentId, request);
        return this.handler.moveToAndRank(EntityContext.from(workItemId, version, expectedPlanVersion, clientId), moveRequest);
    }

    @POST
    public Response moveTo(@PathParam(value="id") String workItemId, @QueryParam(value="version") Long version, @QueryParam(value="planVersion") Long expectedPlanVersion, @QueryParam(value="to") String newParentId, @QueryParam(value="clientId") String clientId, RestMoveAndRankRequest request) throws Exception {
        WorkItemMoveRequest moveRequest = MoveRequestWrapper.create(newParentId, request);
        return this.handler.moveTo(EntityContext.from(workItemId, version, expectedPlanVersion, clientId), moveRequest);
    }
}

