/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.retrafo.solution;

import com.atlassian.rm.jpo.scheduling.util.collection.PositivePrimitivesMap;
import com.google.common.base.Optional;
import com.radiantminds.roadmap.common.data.entities.plans.PlanningUnit;
import com.radiantminds.roadmap.common.scheduling.retrafo.solution.IResourceTypeDescription;
import com.radiantminds.roadmap.common.scheduling.retrafo.solution.ISprintData;
import com.radiantminds.roadmap.common.scheduling.retrafo.solution.WorkStatistics;
import com.radiantminds.roadmap.common.scheduling.retrafo.stats.IWorkSlotData;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
class SprintData
extends WorkStatistics
implements ISprintData {
    private final IWorkSlotData slotStats;
    private final List<IResourceTypeDescription> bottlenecks;
    private final long startTimeStamp;
    private final long endTimeStamp;

    private SprintData(IWorkSlotData slotStats, PlanningUnit planningUnit, double workLoad, double availableWork, PositivePrimitivesMap<IResourceTypeDescription> freeTypes, List<IResourceTypeDescription> bottlenecks, long startTimeStamp, long endTimeStamp) {
        super(planningUnit, slotStats.getAvgResourceUtilization(), workLoad, availableWork, freeTypes);
        this.bottlenecks = Collections.unmodifiableList(bottlenecks);
        this.slotStats = slotStats;
        this.startTimeStamp = startTimeStamp;
        this.endTimeStamp = endTimeStamp;
    }

    @Override
    public String getTeamId() {
        return this.slotStats.getGroupId();
    }

    @Override
    public int getIndex() {
        return this.slotStats.getIndex();
    }

    @Override
    public Optional<String> getSprintId() {
        return this.slotStats.getSlotTitle();
    }

    @Override
    public List<IResourceTypeDescription> getPriorizedBottleneckResourceTypes() {
        return this.bottlenecks;
    }

    @Override
    public long getStartTimeStamp() {
        return this.startTimeStamp;
    }

    @Override
    public long getEndTimeStamp() {
        return this.endTimeStamp;
    }

    static ISprintData create(IWorkSlotData slotData, PlanningUnit planningUnit, double workLoad, double availableWork, PositivePrimitivesMap<IResourceTypeDescription> freeTypes, List<IResourceTypeDescription> bottlenecks, long startTimeStamp, long endTimeStamp) {
        return new SprintData(slotData, planningUnit, workLoad, availableWork, freeTypes, bottlenecks, startTimeStamp, endTimeStamp);
    }
}

