/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.retrafo.stats;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.IWorkResource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.atlassian.rm.jpo.scheduling.util.collection.ImmutableNonEmptyPositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.MutablePositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.PositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.RmCollectionUtils;
import java.util.Map;
import javax.annotation.concurrent.Immutable;

@Immutable
class FreeResourceTypeCalculator {
    FreeResourceTypeCalculator() {
    }

    PositivePrimitivesMap<IResourceType> calculateFreeTypeList(PositivePrimitivesMap<String> availableWorkMap, PositivePrimitivesMap<String> scheduledWorkMap, Map<String, IWorkResource> resourceMap) {
        MutablePositivePrimitivesMap<String> freeWorkAmounts = RmCollectionUtils.newMutablePositiveMap(availableWorkMap);
        freeWorkAmounts.subtract(scheduledWorkMap);
        PositivePrimitivesMap<IResourceType> freeTypeAmounts = this.calculateFreeTypeAmounts(freeWorkAmounts, resourceMap);
        return freeTypeAmounts;
    }

    private PositivePrimitivesMap<IResourceType> calculateFreeTypeAmounts(PositivePrimitivesMap<String> freeWorkAmounts, Map<String, IWorkResource> resourceMap) {
        MutablePositivePrimitivesMap<IResourceType> typeAmounts = RmCollectionUtils.newMutablePositiveMap();
        for (String resource : freeWorkAmounts.keySet()) {
            float freeTime = freeWorkAmounts.get(resource);
            ImmutableNonEmptyPositivePrimitivesMap<IResourceType> efficiencies = resourceMap.get(resource).getTypeSupplies();
            for (IResourceType type : efficiencies.keySet()) {
                float efficiency = efficiencies.get(type);
                float effectiveAmount = efficiency * freeTime;
                typeAmounts.add(type, effectiveAmount);
            }
        }
        return typeAmounts;
    }
}

