/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.trafo.backlog;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.AnnotatedResult;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.dep.DependencyDefinitionFactory;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.dep.IDependencyDefinition;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.time.ITimePlan;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IProcessingItem;
import com.google.common.base.Predicate;
import com.google.common.collect.BiMap;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.entities.workitems.SchedulingWorkItem;
import com.radiantminds.roadmap.common.scheduling.trafo.backlog.JpoDependencyGraph;
import com.radiantminds.roadmap.common.scheduling.trafo.backlog.JpoStructureRecursiveImpl;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import javax.annotation.Nullable;
import org.jgrapht.Graphs;
import org.jgrapht.experimental.dag.DirectedAcyclicGraph;
import org.jgrapht.graph.DefaultEdge;

class DependencyDefinitionTransformer {
    private static final Log LOGGER = Log.with(DependencyDefinitionTransformer.class);
    private final DependencyDefinitionFactory dependencyDefinitionFactory = new DependencyDefinitionFactory();

    DependencyDefinitionTransformer() {
    }

    AnnotatedResult<IDependencyDefinition> createDependencyDefinition(BiMap<IProcessingItem, SchedulingWorkItem> itemMapping, List<? extends SchedulingWorkItem> allWorkItems, ITimePlan timePlan) {
        LOGGER.debug("create dependency definition", new Object[0]);
        JpoStructureRecursiveImpl jpoCausalityGraph = JpoStructureRecursiveImpl.create(allWorkItems);
        AnnotatedResult<IDependencyDefinition> schedulingDependencyGraph = this.createFromStructure(jpoCausalityGraph, itemMapping, timePlan);
        LOGGER.debug("created dependency definition: %s", schedulingDependencyGraph);
        return schedulingDependencyGraph;
    }

    AnnotatedResult<IDependencyDefinition> createFromStructure(JpoDependencyGraph jpoStructure, BiMap<IProcessingItem, SchedulingWorkItem> mapping, ITimePlan timePlan) {
        LOGGER.debug("create scheduling dependency graph", new Object[0]);
        DirectedAcyclicGraph<IProcessingItem, DefaultEdge> schedulingDependencyGraph = new DirectedAcyclicGraph<IProcessingItem, DefaultEdge>(DefaultEdge.class);
        Graphs.addAllVertices(schedulingDependencyGraph, mapping.keySet());
        for (IProcessingItem processingItem : mapping.keySet()) {
            HashSet visited = Sets.newHashSet();
            Stack<SchedulingWorkItem> stack = new Stack<SchedulingWorkItem>();
            Set<SchedulingWorkItem> causalRequirements = jpoStructure.getSelfAndInheritedPrerequisites((SchedulingWorkItem)mapping.get((Object)processingItem));
            stack.addAll(causalRequirements);
            while (!stack.isEmpty()) {
                SchedulingWorkItem nextItem = (SchedulingWorkItem)stack.pop();
                visited.add(nextItem);
                Set<SchedulingWorkItem> leafNodes = jpoStructure.getLeafChildrenOfFamilyOf(nextItem);
                Set<IProcessingItem> prerequisiteItems = DependencyDefinitionTransformer.getSchedulableLeafNodes(leafNodes, mapping);
                if (prerequisiteItems.isEmpty()) {
                    Set<SchedulingWorkItem> nextItems = jpoStructure.getSelfAndInheritedPrerequisites(nextItem);
                    stack.addAll((Collection<SchedulingWorkItem>)Sets.difference(nextItems, (Set)visited));
                    continue;
                }
                for (IProcessingItem prerequisiteItem : prerequisiteItems) {
                    try {
                        schedulingDependencyGraph.addDagEdge(prerequisiteItem, processingItem);
                    }
                    catch (DirectedAcyclicGraph.CycleFoundException e) {
                        LOGGER.error("ignore cyclic dependency for processing item: %s - %s", nextItem.getId(), prerequisiteItem.getId());
                        LOGGER.exception(e);
                    }
                }
            }
        }
        return this.dependencyDefinitionFactory.createInstance(schedulingDependencyGraph, timePlan);
    }

    private static Set<IProcessingItem> getSchedulableLeafNodes(final Set<SchedulingWorkItem> leafNodes, final BiMap<IProcessingItem, SchedulingWorkItem> mapping) {
        return Sets.filter((Set)mapping.keySet(), (Predicate)new Predicate<IProcessingItem>(){

            public boolean apply(@Nullable IProcessingItem iProcessingItem) {
                return leafNodes.contains(mapping.get((Object)iProcessingItem));
            }
        });
    }
}

