/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.trafo.backlog;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.IScheduleViolation;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.MissingWorkTypePerTeamViolation;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.assignment.AssignmentRestriction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.assignment.IResourcePool;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.util.RmSchedulingUtils;
import com.atlassian.rm.jpo.scheduling.util.IIdentifiable;
import com.atlassian.rm.jpo.scheduling.util.RmIdentifiableUtils;
import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.entities.people.SchedulingTeam;
import com.radiantminds.roadmap.common.data.entities.workitems.SchedulingWorkItem;
import com.radiantminds.roadmap.common.scheduling.trafo.backlog.IStorySkillsViolationDetector;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@Immutable
class StorySkillsViolationDetector
implements IStorySkillsViolationDetector {
    StorySkillsViolationDetector() {
    }

    @Override
    public Optional<IScheduleViolation> tryFindMissingTypeViolation(SchedulingWorkItem workItem, Set<IResourceType> specifiedResourceTypes, AssignmentRestriction assignment, Set<SchedulingTeam> ignoredTeams) {
        HashMap missingResourceTypeMap = Maps.newHashMap();
        for (IResourcePool pool : assignment.getResourcePools()) {
            Set<IResourceType> availableTypes = RmSchedulingUtils.getMergedResourceTypes(pool.getResources());
            Sets.SetView missingTypes = Sets.difference(specifiedResourceTypes, availableTypes);
            if (missingTypes.isEmpty()) {
                return Optional.absent();
            }
            Set<String> skillIds = RmIdentifiableUtils.getIds((Collection<? extends IIdentifiable>)missingTypes);
            missingResourceTypeMap.put(pool.getId(), skillIds);
        }
        Set<String> skillIds = RmIdentifiableUtils.getIds(specifiedResourceTypes);
        Set<String> streamAvailableIgnoredTeams = this.getStreamRestictedIgnoredTeamIds(workItem, ignoredTeams);
        for (String id : streamAvailableIgnoredTeams) {
            missingResourceTypeMap.put(id, skillIds);
        }
        MissingWorkTypePerTeamViolation scheduleViolation = new MissingWorkTypePerTeamViolation(workItem.getId(), missingResourceTypeMap, workItem.getResourceIds());
        return Optional.of((Object)scheduleViolation);
    }

    private Set<String> getStreamRestictedIgnoredTeamIds(SchedulingWorkItem workItem, Set<SchedulingTeam> ignoredTeams) {
        Set<String> ignoredTeamIds = RmIdentifiableUtils.getIds(ignoredTeams);
        Set<String> streamRestirctedTeams = workItem.getStreamTeamRestrictions();
        if (streamRestirctedTeams.isEmpty()) {
            return ignoredTeamIds;
        }
        return Sets.intersection(ignoredTeamIds, streamRestirctedTeams);
    }
}

