/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.trafo.backlog;

import com.atlassian.pocketknife.api.logging.Log;
import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.entities.workitems.SchedulingEstimate;
import com.radiantminds.roadmap.common.data.entities.workitems.SchedulingWorkItem;
import com.radiantminds.roadmap.common.data.entities.workitems.WorkItems;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;

class ValidWorkItemPredicate
implements Predicate<SchedulingWorkItem> {
    private static final Log LOGGER = Log.with(ValidWorkItemPredicate.class);
    private static final Set<Integer> CONSIDERED_WORK_ITEM_TYPES = Sets.newHashSet((Object[])new Integer[]{WorkItems.Types.EPIC, WorkItems.Types.STORY});

    ValidWorkItemPredicate() {
    }

    public boolean apply(SchedulingWorkItem input) {
        if (input == null) {
            LOGGER.debug("encountered null item", new Object[0]);
            return false;
        }
        if (!CONSIDERED_WORK_ITEM_TYPES.contains(input.getType())) {
            LOGGER.debug("work item type not considered: %s", input.getType());
            return false;
        }
        String id = input.getId();
        if (input.getSortOrder() == null) {
            LOGGER.debug("item %s has no sort order - ignored", id);
            return false;
        }
        if (!ValidWorkItemPredicate.hasPositiveEstimations(input)) {
            LOGGER.debug("item %s has no positive estimations - ignored", id);
            return false;
        }
        LOGGER.debug("item %s is a valid work item for scheduling", id);
        return true;
    }

    private static boolean hasPositiveEstimations(SchedulingWorkItem workItem) {
        HashSet allEstimates = Sets.newHashSet((Object[])new SchedulingEstimate[]{(SchedulingEstimate)workItem.getTotalEstimate().orNull()});
        allEstimates.addAll(workItem.getStageEstimates());
        allEstimates.addAll(workItem.getSkillEstimates());
        for (SchedulingEstimate estimate : allEstimates) {
            if (!ValidWorkItemPredicate.isPositiveEstimation(estimate)) continue;
            return true;
        }
        return false;
    }

    private static boolean isPositiveEstimation(@Nullable SchedulingEstimate itemEstimate) {
        if (itemEstimate == null) {
            return false;
        }
        Double estimate = itemEstimate.getEstimate();
        if (estimate == null) {
            return false;
        }
        return estimate > 0.0;
    }
}

