/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.trafo.release;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.time.Episode;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.time.IEpisode;
import com.google.common.base.Optional;
import com.radiantminds.roadmap.common.data.entities.releases.SchedulingRelease;
import com.radiantminds.roadmap.common.scheduling.common.ITimeTransformer;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
class ReleaseTransformer {
    private static final Log LOGGER = Log.with(ReleaseTransformer.class);
    private final ITimeTransformer timeTransformer;

    public ReleaseTransformer(ITimeTransformer timeTransformer) {
        this.timeTransformer = timeTransformer;
    }

    public Optional<IEpisode> transform(SchedulingRelease release, List<SchedulingRelease> releases, String streamId) {
        if (releases.get(0).equals(release)) {
            return Optional.of((Object)new Episode(release.getId(), this.getFirstReleaseStart(release), (Integer)this.transformEndTime(release.getFixedEndDate()).orNull(), (Integer)this.transformDuration(release.getDeltaStartDate()).orNull(), null, streamId, release.getIsLaterRelease()));
        }
        Integer fixedStartTime = (Integer)this.transformInstant(release.getFixedStartDate()).orNull();
        Integer startGap = (Integer)this.transformDuration(release.getDeltaStartDate()).orNull();
        if (startGap == null && fixedStartTime == null) {
            fixedStartTime = 0;
        }
        Episode episode = new Episode(release.getId(), fixedStartTime, (Integer)this.transformEndTime(release.getFixedEndDate()).orNull(), startGap, null, streamId, release.getIsLaterRelease());
        return Optional.of((Object)episode);
    }

    private Optional<Integer> transformEndTime(Optional<Long> fixedEndDate) {
        if (!fixedEndDate.isPresent()) {
            return Optional.absent();
        }
        long instant = (Long)fixedEndDate.get();
        if (this.timeTransformer.isBeforeZeroInstant(instant)) {
            return Optional.absent();
        }
        return Optional.of((Object)this.timeTransformer.getTimestep(instant));
    }

    private Optional<Integer> transformDuration(Optional<Long> optionalDelta) {
        if (!optionalDelta.isPresent()) {
            return Optional.absent();
        }
        int gap = this.timeTransformer.getDurationInDays((Long)optionalDelta.get());
        return Optional.of((Object)gap);
    }

    private Optional<Integer> transformInstant(Optional<Long> optionalInstant) {
        LOGGER.debug("transform optional instant: %s", optionalInstant);
        if (!optionalInstant.isPresent()) {
            LOGGER.debug("instant is absent", new Object[0]);
            return Optional.absent();
        }
        int timeStep = 0;
        long longValue = (Long)optionalInstant.get();
        if (!this.timeTransformer.isBeforeZeroInstant(longValue)) {
            timeStep = this.timeTransformer.getTimestep(longValue);
        }
        LOGGER.debug("transformed to timestep: %s", timeStep);
        return Optional.of((Object)timeStep);
    }

    private int getFirstReleaseStart(SchedulingRelease release) {
        Optional<Integer> fixedStartTime = this.transformInstant(release.getFixedStartDate());
        if (fixedStartTime.isPresent()) {
            return (Integer)fixedStartTime.get();
        }
        return this.timeTransformer.getZeroInstantSafeTimestep(this.timeTransformer.getInstant(0) + (Long)release.getDeltaStartDate().or((Object)0L));
    }
}

