/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.trafo.settings;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.processing.IProcessingStage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.processing.ProcessingDefinition;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.processing.ProcessingStage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.entities.plans.SchedulingConfig;
import com.radiantminds.roadmap.common.data.entities.plans.SchedulingPlan;
import com.radiantminds.roadmap.common.data.entities.skills.SchedulingSkill;
import com.radiantminds.roadmap.common.data.entities.skills.SchedulingStage;
import com.radiantminds.roadmap.common.scheduling.common.TimeAmountTransformer;
import com.radiantminds.roadmap.common.scheduling.trafo.settings.IResourceTypeMapping;
import com.radiantminds.roadmap.common.scheduling.trafo.settings.PercentableDistributionExtractor;
import com.radiantminds.roadmap.common.scheduling.trafo.settings.ResourceTypeCreator;
import com.radiantminds.roadmap.common.scheduling.trafo.settings.SchedulingConfigurationTransformationResult;
import com.radiantminds.roadmap.common.scheduling.trafo.settings.SettingsTransformationResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SettingsTransformer {
    private static final Log LOGGER = Log.with(SettingsTransformer.class);
    private final ResourceTypeCreator resourceTypeCreator;
    private final int planningHorizonInDays;
    private final TimeAmountTransformer timeAmountTransformer;

    SettingsTransformer(ResourceTypeCreator resourceTypeCreator, int planningHorizonInDays, TimeAmountTransformer timeAmountTransformer) {
        this.resourceTypeCreator = resourceTypeCreator;
        this.planningHorizonInDays = planningHorizonInDays;
        this.timeAmountTransformer = timeAmountTransformer;
    }

    public SchedulingConfigurationTransformationResult transformSettings(SchedulingPlan plan) {
        LOGGER.debug("create processing definition for plan: %s", plan);
        List<? extends SchedulingStage> stages = plan.getStages();
        Map<SchedulingSkill, Float> skillPercentageMap = this.createSkillPercentageMap(stages);
        Map<SchedulingStage, Float> stagePercentageMap = this.createStagePercentageMap(stages);
        IResourceTypeMapping resourceTypeMapping = this.resourceTypeCreator.createSkillToTypeBiMap(stages, skillPercentageMap);
        List<IProcessingStage> processingStages = this.createProcessingStages(stages, stagePercentageMap, resourceTypeMapping);
        SchedulingConfig planConfiguration = plan.getPlanConfiguration();
        ProcessingDefinition processingDefinition = new ProcessingDefinition(processingStages, planConfiguration.getMaxResourcesPerStory().intValue(), this.timeAmountTransformer.getNormalizedWorkDemand(planConfiguration.getMinLoadUnstrEpics().longValue()), planConfiguration.getHasSprintConstraint(), planConfiguration.getSyncStartEnabled(), this.planningHorizonInDays);
        LOGGER.debug("created processing definition: %s", processingDefinition);
        SettingsTransformationResult transformationResult = new SettingsTransformationResult(processingDefinition, resourceTypeMapping);
        return transformationResult;
    }

    private List<IProcessingStage> createProcessingStages(List<? extends SchedulingStage> stages, Map<SchedulingStage, Float> stagePercentageMap, IResourceTypeMapping resourceTypeMapping) {
        BiMap<SchedulingStage, IProcessingStage> stageToProcessingStageBiMap = this.createProcessingStages(stages, resourceTypeMapping, stagePercentageMap);
        if (stageToProcessingStageBiMap.isEmpty()) {
            return Lists.newArrayList((Object[])new IProcessingStage[]{ProcessingStage.DUMMY_STAGE});
        }
        ArrayList processingStages = Lists.newArrayList();
        for (SchedulingStage schedulingStage : stages) {
            IProcessingStage processingStage = (IProcessingStage)stageToProcessingStageBiMap.get((Object)schedulingStage);
            processingStages.add(processingStage);
        }
        return processingStages;
    }

    private BiMap<SchedulingStage, IProcessingStage> createProcessingStages(List<? extends SchedulingStage> orderedStages, IResourceTypeMapping resourceTypeMapping, Map<SchedulingStage, Float> stagePercentageMap) {
        HashBiMap biMap = HashBiMap.create();
        for (int i = 0; i < orderedStages.size(); ++i) {
            SchedulingStage stage = orderedStages.get(i);
            Set<IResourceType> resourceTypes = resourceTypeMapping.getResourceTypesForStage(stage);
            float percentage = stagePercentageMap.get(stage).floatValue();
            String id = stage.getId();
            String sortKey = stage.getSortOrder().toString();
            ProcessingStage processingStage = new ProcessingStage(id, resourceTypes, percentage, i, null, sortKey);
            biMap.put((Object)stage, (Object)processingStage);
        }
        return biMap;
    }

    private Map<SchedulingSkill, Float> createSkillPercentageMap(List<? extends SchedulingStage> stages) {
        HashMap skillPercMap = Maps.newHashMap();
        for (SchedulingStage schedulingStage : stages) {
            List<? extends SchedulingSkill> skills = schedulingStage.getSkills();
            Map<? extends SchedulingSkill, Float> percentageMap = PercentableDistributionExtractor.createPercentageMap(skills);
            skillPercMap.putAll(percentageMap);
        }
        return skillPercMap;
    }

    private Map<SchedulingStage, Float> createStagePercentageMap(List<? extends SchedulingStage> stages) {
        HashMap stagePercentageMap = Maps.newHashMap();
        HashSet stagesWithNoPercentage = Sets.newHashSet();
        float setPercentageSum = 0.0f;
        for (SchedulingStage schedulingStage : stages) {
            Double percentage = schedulingStage.getPercentage();
            if (percentage == null || stages.size() == 1) {
                stagesWithNoPercentage.add(schedulingStage);
                continue;
            }
            stagePercentageMap.put(schedulingStage, Float.valueOf(percentage.floatValue()));
            setPercentageSum = (float)((double)setPercentageSum + percentage);
        }
        float unassignedPercentages = Math.max(0.0f, 1.0f - setPercentageSum);
        float f = unassignedPercentages / (float)stagesWithNoPercentage.size();
        for (SchedulingStage stage : stagesWithNoPercentage) {
            stagePercentageMap.put(stage, Float.valueOf(f));
        }
        return stagePercentageMap;
    }

    public static SettingsTransformer createInstance(int planningHorizonInDays, TimeAmountTransformer timeAmountTransformer) {
        return new SettingsTransformer(new ResourceTypeCreator(), planningHorizonInDays, timeAmountTransformer);
    }
}

