/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.utils;

import com.radiantminds.roadmap.common.utils.JPOVersionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JPOVersion
implements Comparable<JPOVersion> {
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)[\\.-]?(.*)");
    private final int major;
    private final int minor;
    private final int micro;
    private final String build;

    public JPOVersion(int major, int minor, int micro) {
        this(major, minor, micro, null);
    }

    public JPOVersion(int major, int minor, int micro, String build) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.build = build;
    }

    public JPOVersion(String version) throws JPOVersionException {
        block4: {
            if (version == null) {
                throw new JPOVersionException(null);
            }
            Matcher matcher = VERSION_PATTERN.matcher(version);
            try {
                if (matcher.matches()) {
                    this.major = Integer.parseInt(matcher.group(1));
                    this.minor = Integer.parseInt(matcher.group(2));
                    this.micro = Integer.parseInt(matcher.group(3));
                    String build = matcher.group(4);
                    this.build = build.isEmpty() ? null : build;
                    break block4;
                }
                throw new JPOVersionException(version);
            }
            catch (Exception ex) {
                throw new JPOVersionException(version, ex);
            }
        }
    }

    public boolean isBetween(JPOVersion a, JPOVersion b) {
        return this.isOlderThanOrEqual(b) && this.isNewerThanOrEqual(a);
    }

    public boolean isOlderThan(JPOVersion other) {
        return this.compareTo(other) == -1;
    }

    public boolean isOlderThanOrEqual(JPOVersion other) {
        int comparison = this.compareTo(other);
        return comparison == -1 || comparison == 0;
    }

    public boolean isNewerThan(JPOVersion other) {
        return this.compareTo(other) == 1;
    }

    public boolean isNewerThanOrEqual(JPOVersion other) {
        int comparison = this.compareTo(other);
        return comparison == 1 || comparison == 0;
    }

    @Override
    public int compareTo(JPOVersion o) {
        if (this.major != o.major) {
            return this.major > o.major ? 1 : -1;
        }
        if (this.minor != o.minor) {
            return this.minor > o.minor ? 1 : -1;
        }
        if (this.micro != o.micro) {
            return this.micro > o.micro ? 1 : -1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JPOVersion that = (JPOVersion)o;
        if (this.major != that.major) {
            return false;
        }
        if (this.micro != that.micro) {
            return false;
        }
        return this.minor == that.minor;
    }

    public int hashCode() {
        int result = this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.micro;
        return result;
    }

    public String toString() {
        if (this.build == null) {
            return String.format("%d.%d.%d", this.major, this.minor, this.micro);
        }
        return String.format("%d.%d.%d-%s", this.major, this.minor, this.micro, this.build);
    }
}

