/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.utils.estimate;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.radiantminds.roadmap.common.data.entities.plans.IPlan;
import com.radiantminds.roadmap.common.data.entities.skills.ISkill;
import com.radiantminds.roadmap.common.data.entities.skills.IStage;
import com.radiantminds.roadmap.common.data.entities.workitems.IEstimate;
import com.radiantminds.roadmap.common.data.entities.workitems.IEstimateBlock;
import com.radiantminds.roadmap.common.data.entities.workitems.WorkItemStatus;
import com.radiantminds.roadmap.common.rest.entities.workitems.RestEstimate;
import com.radiantminds.roadmap.common.utils.estimate.EstimateReplanningSuggestion;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

final class EstimateReplanningSuggestionBuilder {
    private static final Function<IEstimate, String> ESTIMATE_INDEX_FUNCTION = new Function<IEstimate, String>(){

        public String apply(@Nullable IEstimate estimate) {
            return String.valueOf(estimate.getTargetId());
        }
    };

    EstimateReplanningSuggestionBuilder() {
    }

    static EstimateReplanningSuggestion build(IEstimateBlock estimates, IPlan plan, Optional<WorkItemStatus> suggestedStatus, Double suggestedTotalEstimate, Map<String, Double> suggestedStageValues, Map<String, Double> suggestedSkillValues) {
        Map<String, IEstimate> suggestedStageEstimates = EstimateReplanningSuggestionBuilder.toEstimateObjects(suggestedStageValues);
        Map<String, IEstimate> suggestedSkillEstimates = EstimateReplanningSuggestionBuilder.toEstimateObjects(suggestedSkillValues);
        ImmutableMap stageEstimates = Maps.uniqueIndex(estimates.getStages(), ESTIMATE_INDEX_FUNCTION);
        ImmutableMap skillEstimates = Maps.uniqueIndex(estimates.getSkills(), ESTIMATE_INDEX_FUNCTION);
        Double total = EstimateReplanningSuggestionBuilder.processTotalSuggestion(estimates.getTotal(), suggestedTotalEstimate);
        Map<String, IEstimate> stages = EstimateReplanningSuggestionBuilder.processStageSuggestions((Map<String, IEstimate>)stageEstimates, suggestedStageEstimates);
        Map<String, IEstimate> skills = EstimateReplanningSuggestionBuilder.processSkillSuggestions(plan, (Map<String, IEstimate>)skillEstimates, suggestedSkillEstimates, (Map<String, IEstimate>)stageEstimates, stages);
        Integer status = null;
        if (suggestedStatus.isPresent() && WorkItemStatus.COMPLETED == suggestedStatus.get()) {
            status = WorkItemStatus.COMPLETED.value();
        }
        return new EstimateReplanningSuggestion(status, total, stages, skills);
    }

    static Map<String, IEstimate> processSkillSuggestions(IPlan plan, Map<String, IEstimate> skillEstimates, Map<String, IEstimate> suggestedSkillEstimates, Map<String, IEstimate> stageEstimates, Map<String, IEstimate> suggestedStageEstimates) {
        HashMap skillHasNeighborEstimates = Maps.newHashMap();
        HashMap skillToParentStage = Maps.newHashMap();
        for (IStage stage : plan.getStages()) {
            boolean hasEstimates = false;
            for (ISkill skill : stage.getSkills()) {
                if (!skillEstimates.containsKey(skill.getId())) continue;
                hasEstimates = true;
                break;
            }
            for (ISkill skill : stage.getSkills()) {
                skillToParentStage.put(skill.getId(), stage.getId());
                skillHasNeighborEstimates.put(skill.getId(), hasEstimates);
            }
        }
        HashMap retVal = Maps.newHashMap();
        for (String skillId : suggestedSkillEstimates.keySet()) {
            boolean add = false;
            Double val = suggestedSkillEstimates.get(skillId).getEstimate();
            if (skillEstimates.containsKey(skillId)) {
                Double origVal = skillEstimates.get(skillId).getEstimate();
                if (!EstimateReplanningSuggestionBuilder.estimateEquals(val, origVal) || val == 0.0 && !val.equals(origVal)) {
                    add = true;
                }
            } else if (val == 0.0) {
                boolean hasNeighbours = skillHasNeighborEstimates.get(skillId) != null && (Boolean)skillHasNeighborEstimates.get(skillId) != false;
                boolean hasParentSuggestion = suggestedStageEstimates.containsKey(skillToParentStage.get(skillId));
                boolean hasParentEstimate = stageEstimates.containsKey(skillToParentStage.get(skillId));
                if (!hasNeighbours && !hasParentSuggestion && hasParentEstimate) {
                    add = true;
                }
            } else {
                add = true;
            }
            if (!add) continue;
            retVal.put(skillId, suggestedSkillEstimates.get(skillId));
        }
        return retVal;
    }

    static Map<String, IEstimate> processStageSuggestions(Map<String, IEstimate> stageEstimates, Map<String, IEstimate> suggestedStageEstimates) {
        HashMap retVal = Maps.newHashMap();
        for (String stageId : suggestedStageEstimates.keySet()) {
            IEstimate estimate = suggestedStageEstimates.get(stageId);
            Double val = estimate.getEstimate();
            boolean add = false;
            if (stageEstimates.containsKey(stageId)) {
                Double origVal = stageEstimates.get(stageId).getEstimate();
                if (!EstimateReplanningSuggestionBuilder.estimateEquals(val, origVal) || val == 0.0 && !val.equals(origVal)) {
                    add = true;
                }
            } else if (val != 0.0 || stageEstimates.size() == 0) {
                add = true;
            }
            if (!add) continue;
            retVal.put(stageId, suggestedStageEstimates.get(stageId));
        }
        return retVal;
    }

    static Double processTotalSuggestion(Optional<IEstimate> totalEstimate, Double suggestedTotalEstimate) {
        if (totalEstimate.isPresent() && suggestedTotalEstimate != null && EstimateReplanningSuggestionBuilder.estimateEquals(suggestedTotalEstimate, ((IEstimate)totalEstimate.get()).getEstimate()) && (suggestedTotalEstimate != 0.0 || suggestedTotalEstimate.equals(((IEstimate)totalEstimate.get()).getEstimate()))) {
            return null;
        }
        return suggestedTotalEstimate;
    }

    private static Map<String, IEstimate> toEstimateObjects(Map<String, Double> estimateValues) {
        HashMap retVal = Maps.newHashMap();
        for (Map.Entry<String, Double> estimate : estimateValues.entrySet()) {
            retVal.put(estimate.getKey(), new RestEstimate(Integer.parseInt(estimate.getKey()), estimate.getValue()));
        }
        return retVal;
    }

    private static boolean estimateEquals(Double suggestedEstimate, Double existingEstimate) {
        if (existingEstimate != null) {
            int roundedEstimate;
            int roundedSuggestion = (int)Math.round(suggestedEstimate * 100.0);
            return roundedSuggestion == (roundedEstimate = (int)Math.round(existingEstimate * 100.0));
        }
        return false;
    }
}

