/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.extension.issues.data.hierarchy;

import com.google.common.collect.Maps;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.hierarchy.HierarchicalJiraIssueData;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.hierarchy.IssueHierarchyJGraphTImpl;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.hierarchy.IssueHierarchyResult;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.hierarchy.LuceneJiraIssueAccessor;
import java.util.HashMap;
import java.util.Set;

public class HierarchicalJiraIssueDataExtractor {
    private final LuceneJiraIssueAccessor luceneJiraIssueAccessor;

    public HierarchicalJiraIssueDataExtractor(LuceneJiraIssueAccessor luceneJiraIssueAccessor) {
        this.luceneJiraIssueAccessor = luceneJiraIssueAccessor;
    }

    public HierarchicalJiraIssueData getData(Set<String> issueKeys) throws Exception {
        long beforeNew = System.currentTimeMillis();
        IssueHierarchyResult luceneIssueHierarchyResult = this.luceneJiraIssueAccessor.retrieveFullHierarchy(issueKeys);
        long lucene = System.currentTimeMillis() - beforeNew;
        HashMap performanceMap = Maps.newHashMap();
        performanceMap.put("GetIssueDataLucene", lucene);
        return IssueHierarchyJGraphTImpl.create(luceneIssueHierarchyResult, performanceMap);
    }
}

