/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.extension.issues.data.time;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.util.RmUtils;
import com.google.common.base.Optional;
import com.radiantminds.roadmap.common.extensions.workitems.WorkData;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.hierarchy.JiraLinkEnrichmentData;
import java.util.Collection;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class JiraIssueTimeData
implements WorkData {
    private static final Log LOGGER = Log.with(JiraIssueTimeData.class);
    private final Long timeSpent;
    private final Long aggregatedTimeSpent;

    JiraIssueTimeData(@Nullable Long timeSpent, @Nullable Long aggregatedTimeSpent) {
        this.timeSpent = timeSpent;
        this.aggregatedTimeSpent = aggregatedTimeSpent;
    }

    @Override
    public Optional<Long> getTimeSpent() {
        return Optional.fromNullable((Object)this.timeSpent);
    }

    @Override
    public Optional<Long> getAggregatedTimeSpent() {
        return Optional.fromNullable((Object)this.aggregatedTimeSpent);
    }

    public String toString() {
        return "JiraIssueTimeData{, timeSpent=" + this.timeSpent + ", aggregatedTimeSpent=" + this.aggregatedTimeSpent + '}';
    }

    public static WorkData create(JiraLinkEnrichmentData issueInfo, @Nullable Collection<JiraLinkEnrichmentData> transitiveSuccessorInfos) {
        LOGGER.debug("extract time related data from Jira issueInfo: %s", issueInfo);
        Long spent = issueInfo.getTimeSpent();
        Long successorSpent = (Long)JiraIssueTimeData.calculateSuccessorSpent(transitiveSuccessorInfos).orNull();
        Long aggregatedSpent = (Long)RmUtils.getOptionalSum(spent, successorSpent).orNull();
        JiraIssueTimeData instance = new JiraIssueTimeData(spent, aggregatedSpent);
        LOGGER.debug("extracted time information: %s", instance);
        return instance;
    }

    private static Optional<Long> calculateSuccessorSpent(@Nullable Collection<JiraLinkEnrichmentData> transitiveSuccessorInfos) {
        if (transitiveSuccessorInfos == null) {
            return Optional.absent();
        }
        long sum = 0L;
        boolean foundNonNull = false;
        for (JiraLinkEnrichmentData transitiveSuccessorInfo : transitiveSuccessorInfos) {
            Long spent = transitiveSuccessorInfo.getTimeSpent();
            if (spent == null) continue;
            sum += spent.longValue();
            foundNonNull = true;
        }
        if (!foundNonNull) {
            return Optional.absent();
        }
        return Optional.of((Object)sum);
    }
}

