/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.extension.issues.search;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.logging.Log;
import com.radiantminds.roadmap.common.extensions.workitems.IIssueRequest;
import com.radiantminds.roadmap.jira.common.components.extension.issues.search.IJiraIssueRequest;
import com.radiantminds.roadmap.jira.common.components.utils.BaseURL;
import com.radiantminds.roadmap.jira.common.components.utils.JiraUserUtil;
import java.util.Set;

public class JiraIssueRequest
implements IJiraIssueRequest {
    private static final Log LOGGER = Log.with(JiraIssueRequest.class);
    private final ApplicationUser user;
    private final String baseUrl;
    private final IIssueRequest request;

    JiraIssueRequest(ApplicationUser user, String baseUrl, IIssueRequest request) {
        this.user = user;
        this.baseUrl = baseUrl;
        this.request = request;
    }

    @Override
    public ApplicationUser getUser() {
        return this.user;
    }

    @Override
    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Override
    public String getQuery() {
        return this.request.getQuery();
    }

    @Override
    public Set<String> getExcludedLinks() {
        return this.request.getExcludedLinks();
    }

    @Override
    public long getResultsLimit() {
        return this.request.getResultsLimit();
    }

    @Override
    public boolean isEpicFetchEnabled() {
        return this.request.isEpicFetchEnabled();
    }

    @Override
    public IIssueRequest.EstimationMethod getEstimationMethod() {
        return this.request.getEstimationMethod();
    }

    public static IJiraIssueRequest createInstance(IIssueRequest request, ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext) {
        LOGGER.debug("create jira issue request for request: %s", request);
        JiraIssueRequest instance = new JiraIssueRequest(JiraUserUtil.getCurrentApplicationUser(authenticationContext), BaseURL.get(applicationProperties), request);
        LOGGER.debug("created instance: %s", instance);
        return instance;
    }
}

