/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.extension.issues.sync.jpo2jira;

import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.MutableIssue;
import com.google.common.base.Optional;
import com.radiantminds.roadmap.common.data.entities.plans.PlanningUnit;
import com.radiantminds.roadmap.common.data.entities.workitems.IWorkItem;
import com.radiantminds.roadmap.common.utils.estimate.EstimateConversionUtil;
import com.radiantminds.roadmap.jira.common.components.extension.issues.sync.EstimateSyncUtils;
import com.radiantminds.roadmap.jira.common.components.issues.sync.SyncTask;

class TimeEstimateSyncTask
implements SyncTask {
    private final Double remaining;
    private final Optional<Double> original;
    private final PlanningUnit planningUnit;
    private final double hoursPerDay;
    private final boolean timeTrackingLegacyMode;
    private final double coefficient;

    public TimeEstimateSyncTask(Double remaining, Optional<Double> original, PlanningUnit planningUnit, double hoursPerDay, boolean timeTrackingLegacyMode) {
        this.remaining = remaining;
        this.original = original;
        this.planningUnit = planningUnit;
        this.hoursPerDay = hoursPerDay;
        this.timeTrackingLegacyMode = timeTrackingLegacyMode;
        this.coefficient = EstimateConversionUtil.getCoefficient(this.planningUnit, this.hoursPerDay);
    }

    @Override
    public boolean apply(MutableIssue issue, IssueInputParameters issueInputParameters) {
        Long onIssue;
        Optional remaining = Optional.of((Object)this.remaining);
        Optional original = this.original;
        if (!original.isPresent()) {
            original = Optional.of((Object)this.remaining);
        }
        if (remaining.isPresent() && (onIssue = issue.getEstimate()) != null && this.coefficient * (double)onIssue.longValue() == (Double)remaining.get()) {
            remaining = Optional.absent();
        }
        if (original.isPresent() && (onIssue = issue.getOriginalEstimate()) != null && this.coefficient * (double)onIssue.longValue() == (Double)original.get()) {
            original = Optional.absent();
        }
        if (!remaining.isPresent() && !original.isPresent()) {
            return false;
        }
        return EstimateSyncUtils.setEstimatesOnJiraIssue(issueInputParameters, (Optional<Double>)remaining, (Optional<Double>)original, this.planningUnit.unit(), this.hoursPerDay, this.timeTrackingLegacyMode);
    }

    @Override
    public boolean apply(IWorkItem workItem) {
        throw new UnsupportedOperationException();
    }
}

