/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.extension.projects;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.common.bridges.agile.AgileNotAvailableException;
import com.atlassian.rm.common.bridges.agile.customfields.AgileCustomFieldNotAvailableException;
import com.atlassian.rm.common.bridges.jira.project.ProjectServiceBridge;
import com.atlassian.rm.common.bridges.jira.project.ProjectServiceBridgeProxy;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.radiantminds.roadmap.common.extensions.projects.IssueTypeData;
import com.radiantminds.roadmap.common.extensions.projects.ListProjectResult;
import com.radiantminds.roadmap.common.extensions.projects.ProjectAccess;
import com.radiantminds.roadmap.common.extensions.projects.ProjectData;
import com.radiantminds.roadmap.common.extensions.projects.ProjectExtension;
import com.radiantminds.roadmap.common.extensions.projects.ProjectIssueTypeData;
import com.radiantminds.roadmap.jira.common.components.agile.JiraAgileAccessor;
import com.radiantminds.roadmap.jira.common.components.utils.BaseURL;
import com.radiantminds.roadmap.jira.common.components.utils.IconURLs;
import com.radiantminds.roadmap.jira.common.components.utils.TimeTracking;
import com.radiantminds.roadmap.jira.common.components.utils.customfields.CustomFields;
import com.radiantminds.roadmap.jira.common.components.utils.customfields.JiraAgileCustomFieldData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JiraProjectExtension
implements ProjectExtension {
    private static final Log LOGGER = Log.with(JiraProjectExtension.class);
    private final ProjectServiceBridgeProxy projectServiceBridgeProxy;
    private final ProjectManager projectManager;
    private final AvatarService avatarService;
    private final CustomFields customFields;
    private final ApplicationProperties applicationProperties;
    private final FieldLayoutManager fieldLayoutManager;
    private final JiraAuthenticationContext authenticationContext;
    private final PermissionManager permissionManager;
    private final JiraAgileAccessor agileAccessor;

    @Autowired
    public JiraProjectExtension(ProjectServiceBridgeProxy projectServiceBridgeProxy, ProjectManager projectManager, AvatarService avatarService, CustomFields customFields, ApplicationProperties applicationProperties, FieldLayoutManager fieldLayoutManager, JiraAuthenticationContext authenticationContext, PermissionManager permissionManager, JiraAgileAccessor agileAccessor) {
        this.projectServiceBridgeProxy = projectServiceBridgeProxy;
        this.projectManager = projectManager;
        this.avatarService = avatarService;
        this.customFields = customFields;
        this.applicationProperties = applicationProperties;
        this.fieldLayoutManager = fieldLayoutManager;
        this.authenticationContext = authenticationContext;
        this.permissionManager = permissionManager;
        this.agileAccessor = agileAccessor;
    }

    @Override
    public ListProjectResult listProjects(final ProjectAccess projectAccess, final String queryString, Integer maxResults, final Set<Long> excludedIds, boolean loadRequiredFields) {
        return this.retrieveProjects(maxResults, new ProjectRetrieval(){

            @Override
            public List<Project> apply() {
                ArrayList retVal = Lists.newArrayList();
                ApplicationUser applicationUser = JiraProjectExtension.this.authenticationContext.getUser();
                List viewableProjects = JiraProjectExtension.this.getAllProjects(applicationUser, projectAccess);
                for (Project project : viewableProjects) {
                    boolean match;
                    String name = project.getName();
                    String key = project.getKey();
                    if (excludedIds != null && excludedIds.contains(project.getId()) || !(match = queryString != null ? name != null && name.toLowerCase().contains(queryString.toLowerCase()) || key != null && key.toLowerCase().contains(queryString.toLowerCase()) : true)) continue;
                    retVal.add(project);
                }
                return retVal;
            }
        }, loadRequiredFields);
    }

    @Override
    public ListProjectResult getDefaultedProject(final ProjectAccess projectAccess, final Long projectId, boolean loadRequiredFields) {
        return this.retrieveProjects(null, new ProjectRetrieval(){

            @Override
            public List<Project> apply() {
                ApplicationUser applicationUser = JiraProjectExtension.this.authenticationContext.getUser();
                ProjectService.GetProjectResult getResult = ((ProjectServiceBridge)JiraProjectExtension.this.projectServiceBridgeProxy.get()).getProjectById(applicationUser, projectId);
                if (getResult.isValid() && getResult.getProject() != null && JiraProjectExtension.this.checkPermission(getResult.getProject(), applicationUser, projectAccess)) {
                    return Lists.newArrayList((Object[])new Project[]{getResult.getProject()});
                }
                List viewableProjects = JiraProjectExtension.this.getAllProjects(applicationUser, projectAccess);
                if (viewableProjects.size() > 0) {
                    return Lists.newArrayList((Object[])new Project[]{(Project)viewableProjects.get(0)});
                }
                return Lists.newArrayList();
            }
        }, loadRequiredFields);
    }

    private List<Project> getAllProjects(final ApplicationUser user, final ProjectAccess projectAccess) {
        List allProjects = this.projectManager.getProjectObjects();
        if (allProjects == null) {
            LOGGER.warn("Failed to retrieve projects.", new Object[0]);
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Iterable)Iterables.filter((Iterable)allProjects, (Predicate)new Predicate<Project>(){

            public boolean apply(@Nullable Project project) {
                return JiraProjectExtension.this.checkPermission(project, user, projectAccess);
            }
        }));
    }

    private boolean checkPermission(Project project, ApplicationUser user, ProjectAccess projectAccess) {
        return projectAccess == ProjectAccess.BROWSE ? this.permissionManager.hasPermission(10, project, user) : (projectAccess == ProjectAccess.CREATE_ISSUES ? this.permissionManager.hasPermission(11, project, user) : this.permissionManager.hasPermission(23, project, user));
    }

    private ListProjectResult retrieveProjects(Integer maxResults, ProjectRetrieval retrieval, boolean loadRequiredFields) {
        String baseUrl = BaseURL.get(this.applicationProperties);
        JiraAgileCustomFieldData agileCustomFieldData = null;
        boolean agileCustomFieldsUnavailable = false;
        if (this.agileAccessor.isUsable()) {
            try {
                agileCustomFieldData = this.customFields.getJiraAgileData();
            }
            catch (AgileNotAvailableException agileNotAvailableException) {
            }
            catch (AgileCustomFieldNotAvailableException e) {
                agileCustomFieldsUnavailable = true;
            }
        }
        ArrayList projects = Lists.newArrayList();
        HashMap issueTypes = Maps.newHashMap();
        boolean moreAvailable = false;
        List<Project> retrievedProjects = retrieval.apply();
        for (Project project : retrievedProjects) {
            if (maxResults != null && projects.size() == maxResults.intValue()) {
                moreAvailable = true;
                break;
            }
            ArrayList projectIssueTypes = Lists.newArrayList();
            for (IssueType type : project.getIssueTypes()) {
                if (type.isSubTask()) continue;
                String id = type.getId();
                ArrayList requiredFields = Lists.newArrayList();
                if (loadRequiredFields) {
                    FieldLayout layout = this.fieldLayoutManager.getFieldLayout(project, id);
                    for (FieldLayoutItem item : layout.getRequiredFieldLayoutItems(project, (List)Lists.newArrayList((Object[])new String[]{id}))) {
                        requiredFields.add(item.getOrderableField().getId());
                    }
                }
                projectIssueTypes.add(new ProjectIssueTypeData.Impl(id, type.getName(), requiredFields));
                boolean storyPointEnabled = agileCustomFieldData != null && (agileCustomFieldData.getStoryPointsCustomField().isGlobal() || agileCustomFieldData.getStoryPointEnabledIssueTypeIds().contains(id));
                IssueTypeData.Impl issueType = new IssueTypeData.Impl(id, type.getName(), type.getDescription(), IconURLs.adapt(baseUrl, type.getIconUrl()), type.isSubTask(), storyPointEnabled);
                issueTypes.put(id, issueType);
            }
            if (projectIssueTypes.size() <= 0) continue;
            String avatarUrl = this.avatarService.getProjectAvatarURL(project, Avatar.Size.SMALL).toString();
            projects.add(new ProjectData.Impl(project.getId(), project.getKey(), project.getName(), avatarUrl, projectIssueTypes));
        }
        boolean timeTrackingEnabled = TimeTracking.isEnabled(this.applicationProperties);
        if (agileCustomFieldData != null) {
            return new ListProjectResult.Impl(projects, Lists.newArrayList(issueTypes.values()), moreAvailable, timeTrackingEnabled, agileCustomFieldData.getEpicIssueTypeId(), agileCustomFieldData.getEpicLinkField().getId(), agileCustomFieldData.getEpicLabelField().getId(), agileCustomFieldData.getStoryPointsCustomField().getId(), false);
        }
        return new ListProjectResult.Impl(projects, Lists.newArrayList(issueTypes.values()), moreAvailable, timeTrackingEnabled, null, null, null, null, agileCustomFieldsUnavailable);
    }

    private static interface ProjectRetrieval {
        public List<Project> apply();
    }
}

