/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.extension.users;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.rm.common.bridges.jira.group.GroupManagerBridge;
import com.atlassian.rm.common.bridges.jira.group.GroupManagerBridgeProxy;
import com.atlassian.rm.common.bridges.jira.user.UserSearchServiceBridge;
import com.atlassian.rm.common.bridges.jira.user.UserSearchServiceBridgeProxy;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.entities.permissions.IPermission;
import com.radiantminds.roadmap.common.extensions.users.UserData;
import com.radiantminds.roadmap.common.extensions.users.UserExtension;
import com.radiantminds.roadmap.common.rest.entities.system.RestGroupAndUserListItem;
import com.radiantminds.roadmap.jira.common.components.utils.Distribution;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JiraUserExtension
implements UserExtension {
    private static final List<String> SYSADMIN_RESTRICTED_GROUPS = Lists.newArrayList();
    private final JiraAuthenticationContext authenticationContext;
    private final GroupManager groupManager;
    private final GroupManagerBridgeProxy groupManagerBridgeProxy;
    private final UserManager userManager;
    private final GlobalPermissionManager globalPermissionManager;
    private final FeatureManager featureManager;
    private final UserSearchServiceBridgeProxy userSearchServiceBridgeProxy;

    @Autowired
    public JiraUserExtension(JiraAuthenticationContext authenticationContext, GroupManager groupManager, GroupManagerBridgeProxy groupManagerBridgeProxy, UserManager userManager, GlobalPermissionManager globalPermissionManager, FeatureManager featureManager, UserSearchServiceBridgeProxy userSearchServiceBridgeProxy) {
        this.authenticationContext = authenticationContext;
        this.groupManager = groupManager;
        this.groupManagerBridgeProxy = groupManagerBridgeProxy;
        this.userManager = userManager;
        this.globalPermissionManager = globalPermissionManager;
        this.featureManager = featureManager;
        this.userSearchServiceBridgeProxy = userSearchServiceBridgeProxy;
    }

    @Override
    public UserData getActiveUserData() {
        ApplicationUser user = this.authenticationContext.getUser();
        Collection<Group> groups = ((GroupManagerBridge)this.groupManagerBridgeProxy.get()).getGroupsForUser(user);
        HashSet groupIds = Sets.newHashSet((Iterable)Iterables.transform(groups, (Function)new Function<Group, String>(){

            public String apply(@Nullable Group group) {
                return group.getName();
            }
        }));
        boolean sysAdmin = this.globalPermissionManager.hasPermission(44, user);
        boolean administrator = this.globalPermissionManager.hasPermission(0, user) || sysAdmin;
        return new UserData(user.getKey(), groupIds, administrator, sysAdmin);
    }

    @Override
    public boolean doesGroupSysadminRestrictionApply(UserData userData, String group) {
        if (!Distribution.isOnDemand(this.featureManager)) {
            return false;
        }
        if (userData.isSysAdmin()) {
            return false;
        }
        return SYSADMIN_RESTRICTED_GROUPS.contains(group);
    }

    @Override
    public String getDisplayName(String userId) {
        ApplicationUser user = this.userManager.getUserByKey(userId);
        if (user != null) {
            return String.format("%s (%s)", user.getDisplayName(), user.getName());
        }
        return null;
    }

    @Override
    public <T extends IPermission> List<T> removeMissingEntries(Iterable<T> entries) {
        ArrayList retVal = Lists.newArrayList();
        for (IPermission entry : entries) {
            if ("group".equals(entry.getHolderType())) {
                if (this.groupManager.getGroup(entry.getHolderId()) == null) continue;
                retVal.add(entry);
                continue;
            }
            if (this.userManager.getUserByKey(entry.getHolderId()) == null) continue;
            retVal.add(entry);
        }
        return retVal;
    }

    @Override
    public List<RestGroupAndUserListItem> listGroups(String query, List<String> excludes, int maxResults) {
        String lowerCaseQuery = query != null ? query.toLowerCase() : query;
        UserData user = this.getActiveUserData();
        ArrayList retVal = Lists.newArrayList();
        Set groups = user.isAdministrator() || user.isSysAdmin() ? this.userManager.getAllGroups() : ((GroupManagerBridge)this.groupManagerBridgeProxy.get()).getGroupsForUser(this.authenticationContext.getUser());
        for (Group group : groups) {
            if (retVal.size() == maxResults) break;
            String groupName = group.getName();
            if (excludes != null && excludes.contains(groupName) || query != null && !groupName.toLowerCase().contains(lowerCaseQuery) || this.doesGroupSysadminRestrictionApply(user, group.getName())) continue;
            RestGroupAndUserListItem item = new RestGroupAndUserListItem(group.getName(), null, group.getName());
            retVal.add(item);
        }
        return retVal;
    }

    @Override
    public List<RestGroupAndUserListItem> listUsers(String query, List<String> excludes, @Nullable Integer maxResults) {
        UserSearchServiceBridge userSearchServiceBridge = (UserSearchServiceBridge)this.userSearchServiceBridgeProxy.get();
        ArrayList retVal = Lists.newArrayList();
        for (ApplicationUser user : userSearchServiceBridge.findUsersByName(this.authenticationContext.getUser(), query, (Optional<Integer>)Optional.fromNullable((Object)maxResults), excludes)) {
            RestGroupAndUserListItem item = new RestGroupAndUserListItem(user.getDisplayName(), user.getName(), user.getKey());
            retVal.add(item);
        }
        return retVal;
    }
}

