/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.kit.datecalc.common;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import net.objectlab.kit.datecalc.common.Utils;

public final class ExcelDateUtil {
    private static final double HALF_MILLISEC = 0.5;
    private static final int EXCEL_FUDGE_19000229 = 61;
    private static final int EXCEL_WINDOWING_1904 = 1904;
    private static final int EXCEL_BASE_YEAR = 1900;
    private static final long DAY_MILLISECONDS = 86400000L;

    private ExcelDateUtil() {
    }

    public static Calendar getJavaCalendar(double excelDate, boolean use1904windowing) {
        if (ExcelDateUtil.isValidExcelDate(excelDate)) {
            int startYear = 1900;
            int dayAdjust = -1;
            int wholeDays = (int)Math.floor(excelDate);
            if (use1904windowing) {
                startYear = 1904;
                dayAdjust = 1;
            } else if (wholeDays < 61) {
                dayAdjust = 0;
            }
            GregorianCalendar calendar = new GregorianCalendar(startYear, 0, wholeDays + dayAdjust);
            int millisecondsInDay = (int)((excelDate - Math.floor(excelDate)) * 8.64E7 + 0.5);
            calendar.set(14, millisecondsInDay);
            return calendar;
        }
        return null;
    }

    public static Date getJavaDateOnly(double excelDate, boolean use1904windowing) {
        Calendar javaCalendar = ExcelDateUtil.getJavaCalendar(excelDate, use1904windowing);
        if (javaCalendar == null) {
            return null;
        }
        return Utils.blastTime(javaCalendar).getTime();
    }

    public static Date getJavaDate(double excelDate, boolean use1904windowing) {
        Calendar cal = ExcelDateUtil.getJavaCalendar(excelDate, use1904windowing);
        return cal == null ? null : cal.getTime();
    }

    public static boolean isValidExcelDate(double excelDate) {
        return excelDate > -4.9E-324;
    }
}

