/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.kit.datecalc.common;

import java.io.Serializable;
import net.objectlab.kit.datecalc.common.TenorCode;

public class Tenor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int units = 0;
    private TenorCode code;

    public Tenor(int units, TenorCode code) {
        this.units = units;
        this.code = code;
    }

    public int getUnits() {
        return this.units;
    }

    public TenorCode getCode() {
        return this.code;
    }

    public boolean hasUnits() {
        return this.code.acceptUnits();
    }

    public String toString() {
        return (this.units != 0 ? "" + this.units : "") + this.code.getCode();
    }

    public static Tenor valueOf(String tenor) {
        TenorCode parsedCode;
        StringBuffer unitsBuf = new StringBuffer();
        StringBuffer codeBuf = new StringBuffer();
        boolean invalid = false;
        int size = tenor.length();
        Tenor.parseCode(tenor, unitsBuf, codeBuf, invalid, size);
        int parsedUnits = 0;
        if (unitsBuf.length() > 0) {
            parsedUnits = Integer.parseInt(unitsBuf.toString());
        }
        if ((parsedCode = TenorCode.fromCode(codeBuf.toString())) == null) {
            throw new IllegalArgumentException("[" + codeBuf + "] is not a valid TenorCode");
        }
        if (!parsedCode.acceptUnits() && unitsBuf.length() > 0) {
            throw new IllegalArgumentException("[" + codeBuf + "] does not accept units");
        }
        if (parsedCode.acceptUnits() && unitsBuf.length() == 0) {
            throw new IllegalArgumentException("[" + codeBuf + "] requires units");
        }
        return new Tenor(parsedUnits, parsedCode);
    }

    private static void parseCode(String tenor, StringBuffer unitsBuf, StringBuffer codeBuf, boolean invalid, int size) {
        for (int i = 0; i < size && !invalid; ++i) {
            char c = tenor.charAt(i);
            if (c >= '0' && c <= '9') {
                if (codeBuf.length() != 0) {
                    throw new IllegalArgumentException("[" + tenor + "] is not a valid tenor");
                }
                unitsBuf.append(c);
                continue;
            }
            codeBuf.append(c);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.code == null ? 0 : this.code.hashCode());
        result = 31 * result + this.units;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Tenor other = (Tenor)obj;
        if (this.code == null ? other.code != null : !this.code.equals((Object)other.code)) {
            return false;
        }
        return this.units == other.units;
    }
}

