/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.utils;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.javasimon.StopwatchSample;
import org.javasimon.utils.Replacer;

public final class GoogleChartImageGenerator {
    private static final int FIXED_WIDTH = 100;
    private static final int BAR_WIDTH = 80;
    private static final int BAR_SPACING = 40;
    private static final int BAR_SPACING_MAX_MIN = 25;
    private static final int IMAGE_HEIGHT = 320;
    private static final String URL_START = "http://chart.apis.google.com/chart?chs=";
    private static final String TYPE_BAR1 = "&cht=bvg&chbh=a,3,";
    private static final String TYPE_BAR2 = "&chco=2d69f9,a6c9fd,d0eeff&chxt=y,x,x";
    private static final DecimalFormat NUMBER_FORMAT = new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.US));
    private static final List<Replacer> REPLACERS = new LinkedList<Replacer>();
    private static final int TEN_BASE = 10;
    private StopwatchSample[] samples;
    private String title;
    private double divisor;
    private String unit;
    private boolean showMaxMin;
    private double max = 0.0;
    private boolean first = true;

    private GoogleChartImageGenerator(StopwatchSample[] samples, String title, double divisor, String unit, boolean showMaxMin) {
        this.samples = samples;
        this.title = title;
        this.divisor = divisor;
        this.unit = unit;
        this.showMaxMin = showMaxMin;
    }

    public static String barChart(StopwatchSample[] samples, String title, double divisor, String unit, boolean showMaxMin) {
        return new GoogleChartImageGenerator(samples, title, divisor, unit, showMaxMin).process();
    }

    private String process() {
        double x;
        StringBuilder result = new StringBuilder(URL_START);
        int setSpacing = 40;
        if (this.showMaxMin) {
            setSpacing = 25;
        }
        result.append(100 + 80 * this.samples.length).append('x').append(320).append(TYPE_BAR1).append(setSpacing).append(TYPE_BAR2);
        if (this.showMaxMin) {
            result.append(",x,x");
        }
        result.append("&chtt=").append(GoogleChartImageGenerator.encode(this.title));
        StringBuilder simonNamesAxis = new StringBuilder("|1:");
        StringBuilder meanValuesAxis = new StringBuilder("|2:");
        StringBuilder maxValuesAxis = new StringBuilder("|3:");
        StringBuilder minValuesAxis = new StringBuilder("|4:");
        StringBuilder meanData = new StringBuilder("&chd=t:");
        StringBuilder maxData = new StringBuilder("|");
        StringBuilder minData = new StringBuilder("|");
        for (StopwatchSample sample : this.samples) {
            if (this.first) {
                this.first = false;
            } else {
                meanData.append(',');
                maxData.append(',');
                minData.append(',');
            }
            simonNamesAxis.append('|').append(GoogleChartImageGenerator.encode(sample.getName()));
            meanData.append(this.addValueToAxis(meanValuesAxis, sample.getMean()));
            if (!this.showMaxMin) continue;
            maxData.append(this.addValueToAxis(maxValuesAxis, sample.getMax()));
            minData.append(this.addValueToAxis(minValuesAxis, sample.getMin()));
        }
        double division = Math.pow(10.0, Math.floor(Math.log10(this.max)));
        StringBuilder yAxis = new StringBuilder("&chxl=0:");
        for (x = 0.0; x < this.max + division; x += division) {
            yAxis.append('|').append(Double.valueOf(x).longValue());
        }
        result.append("&chxr=2,0,").append(Double.valueOf(x - division).longValue());
        result.append("&chds=0,").append(Double.valueOf(x - division).longValue());
        result.append((CharSequence)yAxis).append((CharSequence)simonNamesAxis).append((CharSequence)meanValuesAxis);
        if (this.showMaxMin) {
            result.append((CharSequence)maxValuesAxis).append((CharSequence)minValuesAxis);
        }
        result.append((CharSequence)meanData);
        if (this.showMaxMin) {
            result.append((CharSequence)maxData).append((CharSequence)minData);
        }
        result.append("&chdl=avg").append(this.showMaxMin ? "|max|min" : "").append("&.png");
        return result.toString();
    }

    private String addValueToAxis(StringBuilder axis, double value) {
        if ((value /= this.divisor) > this.max) {
            this.max = value;
        }
        String formattedValue = NUMBER_FORMAT.format(value);
        axis.append('|').append(formattedValue).append("+").append(this.unit);
        return formattedValue;
    }

    private static String encode(String s) {
        for (Replacer replacer : REPLACERS) {
            s = replacer.process(s);
        }
        return s;
    }

    static {
        REPLACERS.add(new Replacer("\\+", "%2b", new Replacer.Modificator[0]));
        REPLACERS.add(new Replacer(" ", "+", new Replacer.Modificator[0]));
        REPLACERS.add(new Replacer("&", "%26", new Replacer.Modificator[0]));
    }
}

