/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.utils;

import org.javasimon.Stopwatch;
import org.javasimon.StopwatchSample;

public final class GoogleInteractiveChartGenerator {
    private static final int ONE_BAR_WIDTH = 100;

    private GoogleInteractiveChartGenerator() {
        throw new AssertionError();
    }

    public static String barChart(StopwatchSample[] samples, String title, double divisor, String unit) {
        StringBuilder result = new StringBuilder("<html>\n  <head>\n    <script type=\"text/javascript\" src=\"https://www.google.com/jsapi\"></script>\n    <script type=\"text/javascript\">\n      google.load(\"visualization\", \"1\", {packages:[\"corechart\"]});\n      google.setOnLoadCallback(drawChart);\n      function drawChart() {\n        var data = new google.visualization.DataTable();\n");
        result.append("        data.addColumn('string', 'stopwatch');\n        data.addColumn('number', 'avg');\n        data.addColumn('number', 'max');\n        data.addColumn('number', 'min');\n        data.addRows(").append(samples.length).append(");\n");
        int rowIndex = 0;
        for (StopwatchSample sample : samples) {
            Stopwatch stopwatch = (Stopwatch)((Object)sample);
            result.append("        data.setValue(").append(rowIndex).append(", 0, '").append(stopwatch.getName()).append("');\n").append("        data.setValue(").append(rowIndex).append(", 1, ").append(stopwatch.getMean() / divisor).append(");\n").append("        data.setValue(").append(rowIndex).append(", 2, ").append((double)stopwatch.getMax() / divisor).append(");\n").append("        data.setValue(").append(rowIndex).append(", 3, ").append((double)stopwatch.getMin() / divisor).append(");\n");
            ++rowIndex;
        }
        result.append("        var chart = new google.visualization.ColumnChart(document.getElementById('chart_div'));\n        chart.draw(data, {width: ").append(100 * (1 + samples.length)).append(", height: 600, title: '").append(title).append("',\n                          hAxis: {title: 'stopwatch', titleTextStyle: {color: 'red'}}\n                         });\n      }\n    </script>\n  </head>\n\n  <body>\n    <div id=\"chart_div\"></div>\n  </body>\n</html>");
        return result.toString();
    }
}

