/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.jgrapht.DirectedGraph;
import org.jgrapht.alg.interfaces.StrongConnectivityAlgorithm;
import org.jgrapht.graph.DirectedSubgraph;

public class GabowStrongConnectivityInspector<V, E>
implements StrongConnectivityAlgorithm<V, E> {
    private final DirectedGraph<V, E> graph;
    private Deque<VertexNumber<V>> stack = new ArrayDeque<VertexNumber<V>>();
    private List<Set<V>> stronglyConnectedSets;
    private List<DirectedSubgraph<V, E>> stronglyConnectedSubgraphs;
    private Map<V, VertexNumber<V>> vertexToVertexNumber;
    private Deque<Integer> B = new ArrayDeque<Integer>();
    private int c;

    public GabowStrongConnectivityInspector(DirectedGraph<V, E> directedGraph) {
        if (directedGraph == null) {
            throw new IllegalArgumentException("null not allowed for graph!");
        }
        this.graph = directedGraph;
        this.vertexToVertexNumber = null;
        this.stronglyConnectedSets = null;
    }

    @Override
    public DirectedGraph<V, E> getGraph() {
        return this.graph;
    }

    @Override
    public boolean isStronglyConnected() {
        return this.stronglyConnectedSets().size() == 1;
    }

    @Override
    public List<Set<V>> stronglyConnectedSets() {
        if (this.stronglyConnectedSets == null) {
            this.stronglyConnectedSets = new Vector<Set<V>>();
            this.createVertexNumber();
            for (VertexNumber<V> data : this.vertexToVertexNumber.values()) {
                if (data.getNumber() != 0) continue;
                this.dfsVisit(this.graph, data);
            }
            this.vertexToVertexNumber = null;
            this.stack = null;
            this.B = null;
        }
        return this.stronglyConnectedSets;
    }

    @Override
    public List<DirectedSubgraph<V, E>> stronglyConnectedSubgraphs() {
        if (this.stronglyConnectedSubgraphs == null) {
            List<Set<V>> sets = this.stronglyConnectedSets();
            this.stronglyConnectedSubgraphs = new Vector<DirectedSubgraph<V, E>>(sets.size());
            for (Set<V> set : sets) {
                this.stronglyConnectedSubgraphs.add(new DirectedSubgraph<V, E>(this.graph, set, null));
            }
        }
        return this.stronglyConnectedSubgraphs;
    }

    private void createVertexNumber() {
        this.c = this.graph.vertexSet().size();
        this.vertexToVertexNumber = new HashMap<V, VertexNumber<V>>(this.c);
        for (Object vertex : this.graph.vertexSet()) {
            this.vertexToVertexNumber.put(vertex, new VertexNumber(vertex, 0));
        }
        this.stack = new ArrayDeque<VertexNumber<V>>(this.c);
        this.B = new ArrayDeque<Integer>(this.c);
    }

    private void dfsVisit(DirectedGraph<V, E> visitedGraph, VertexNumber<V> v) {
        this.stack.add(v);
        this.B.add(v.setNumber(this.stack.size() - 1));
        for (E edge : visitedGraph.outgoingEdgesOf(v.getVertex())) {
            VertexNumber<V> w = this.vertexToVertexNumber.get(visitedGraph.getEdgeTarget(edge));
            if (w.getNumber() == 0) {
                this.dfsVisit(this.graph, w);
                continue;
            }
            while (w.getNumber() < this.B.getLast()) {
                this.B.removeLast();
            }
        }
        HashSet<V> L = new HashSet<V>();
        if (v.getNumber() == this.B.getLast().intValue()) {
            this.B.removeLast();
            ++this.c;
            while (v.getNumber() <= this.stack.size() - 1) {
                VertexNumber<V> r = this.stack.removeLast();
                L.add(r.getVertex());
                r.setNumber(this.c);
            }
            this.stronglyConnectedSets.add(L);
        }
    }

    private static final class VertexNumber<V> {
        V vertex;
        int number = 0;

        private VertexNumber(V vertex, int number) {
            this.vertex = vertex;
            this.number = number;
        }

        int getNumber() {
            return this.number;
        }

        V getVertex() {
            return this.vertex;
        }

        Integer setNumber(int n) {
            this.number = n;
            return this.number;
        }
    }
}

