/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg.flow;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import org.jgrapht.DirectedGraph;
import org.jgrapht.alg.flow.MaximumFlowAlgorithmBase;
import org.jgrapht.alg.interfaces.MaximumFlowAlgorithm;
import org.jgrapht.alg.util.Extension;
import org.jgrapht.alg.util.Pair;

public class PushRelabelMaximumFlow<V, E>
extends MaximumFlowAlgorithmBase<V, E> {
    private static final boolean DIAGNOSTIC_ENABLED = false;
    private DirectedGraph<V, E> network;
    private final Extension.ExtensionFactory<VertexExtension> vertexExtensionsFactory;
    private final Extension.ExtensionFactory<EdgeExtension> edgeExtensionsFactory;
    private Map<Integer, Integer> labeling;
    boolean flowBack;
    private PushRelabelDiagnostic diagnostic;

    public PushRelabelMaximumFlow(DirectedGraph<V, E> network) {
        this.network = network;
        this.vertexExtensionsFactory = new Extension.ExtensionFactory<VertexExtension>(){

            @Override
            public VertexExtension create() {
                return new VertexExtension();
            }
        };
        this.edgeExtensionsFactory = new Extension.ExtensionFactory<EdgeExtension>(){

            @Override
            public EdgeExtension create() {
                return new EdgeExtension();
            }
        };
    }

    void init() {
        super.init(this.vertexExtensionsFactory, this.edgeExtensionsFactory);
        this.labeling = new HashMap<Integer, Integer>();
        this.flowBack = false;
    }

    @Override
    DirectedGraph<V, E> getNetwork() {
        return this.network;
    }

    public void initialize(VertexExtension source, VertexExtension sink, Queue<VertexExtension> active) {
        source.label = this.network.vertexSet().size();
        source.excess = Double.POSITIVE_INFINITY;
        this.label(source, sink);
        for (EdgeExtension ex : source.getOutgoing()) {
            this.pushFlowThrough(ex, ex.capacity);
            if (ex.getTarget().prototype == sink.prototype) continue;
            active.offer((VertexExtension)ex.getTarget());
        }
    }

    private void label(VertexExtension source, VertexExtension sink) {
        HashSet<VertexExtension> seen = new HashSet<VertexExtension>();
        ArrayDeque<VertexExtension> q = new ArrayDeque<VertexExtension>();
        q.offer(sink);
        sink.label = 0;
        seen.add(sink);
        seen.add(source);
        while (!q.isEmpty()) {
            VertexExtension ux = (VertexExtension)q.poll();
            for (EdgeExtension ex : ux.getOutgoing()) {
                VertexExtension vx = (VertexExtension)ex.getTarget();
                if (seen.contains(vx)) continue;
                seen.add(vx);
                vx.label = ux.label + 1;
                q.add(vx);
                if (!this.labeling.containsKey(vx.label)) {
                    this.labeling.put(vx.label, 1);
                    continue;
                }
                this.labeling.put(vx.label, this.labeling.get(vx.label) + 1);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public MaximumFlowAlgorithm.MaximumFlow<V, E> buildMaximumFlow(V source, V sink) {
        this.init();
        active = new ArrayDeque<VertexExtension>();
        this.initialize(this.extendedVertex(source), this.extendedVertex(sink), active);
        block0: while (!active.isEmpty()) {
            ux = (VertexExtension)active.poll();
            while (true) {
                for (EdgeExtension ex : ux.getOutgoing()) {
                    if (!this.isAdmissible(ex)) continue;
                    if (ex.getTarget().prototype != sink && ex.getTarget().prototype != source) {
                        active.offer((VertexExtension)ex.getTarget());
                    }
                    if (!this.discharge(ex)) continue;
                    break;
                }
                if (!VertexExtension.access$100(ux)) continue block0;
                this.relabel(ux);
                if (this.flowBack || this.labeling.containsKey(0) || this.labeling.containsKey(1)) ** continue;
                VertexExtension.access$002(this.extendedVertex(source), Collections.max(this.labeling.keySet()) + 1);
                this.flowBack = true;
            }
        }
        maxFlow = this.composeFlow();
        maxFlowValue = 0.0;
        for (E e : this.network.incomingEdgesOf(sink)) {
            maxFlowValue += maxFlow.get(e).doubleValue();
        }
        return new MaximumFlowAlgorithm.MaximumFlowImpl<V, E>(maxFlowValue, maxFlow);
    }

    private void relabel(VertexExtension vx) {
        assert (vx.hasExcess());
        int min = Integer.MAX_VALUE;
        for (EdgeExtension ex : vx.getOutgoing()) {
            VertexExtension ux;
            if (!ex.hasCapacity() || min <= (ux = (VertexExtension)ex.getTarget()).label) continue;
            min = ux.label;
        }
        assert (this.labeling.get(vx.label) > 0);
        this.updateLabeling(vx, min + 1);
        if (min != Integer.MAX_VALUE) {
            vx.label = min + 1;
        }
    }

    private void updateLabeling(VertexExtension vx, int l) {
        if (this.labeling.get(vx.label) == 1) {
            this.labeling.remove(vx.label);
        } else {
            this.labeling.put(vx.label, this.labeling.get(vx.label) - 1);
        }
        if (!this.labeling.containsKey(l)) {
            this.labeling.put(l, 1);
        } else {
            this.labeling.put(l, this.labeling.get(l) + 1);
        }
    }

    private boolean discharge(EdgeExtension ex) {
        VertexExtension ux = (VertexExtension)ex.getSource();
        this.pushFlowThrough(ex, Math.min(ux.excess, ex.capacity - ex.flow));
        return !ux.hasExcess();
    }

    protected void pushFlowThrough(EdgeExtension ex, double f) {
        ex.getSource().excess -= f;
        ex.getTarget().excess += f;
        assert (ex.getSource().excess >= 0.0 && ex.getTarget().excess >= 0.0);
        super.pushFlowThrough(ex, f);
    }

    private boolean isAdmissible(EdgeExtension e) {
        return e.hasCapacity() && ((VertexExtension)e.getSource()).label == ((VertexExtension)e.getTarget()).label + 1;
    }

    private EdgeExtension extendedEdge(E e) {
        return (EdgeExtension)this.edgeExtended(e);
    }

    private VertexExtension extendedVertex(V v) {
        return (VertexExtension)this.vertexExtended(v);
    }

    public class EdgeExtension
    extends MaximumFlowAlgorithmBase.EdgeExtensionBase {
        private boolean hasCapacity() {
            return PushRelabelMaximumFlow.this.compareFlowTo(this.capacity, this.flow) > 0;
        }

        public String toString() {
            return this.prototype.toString() + String.format(" { F/CAP: %f / %f } ", this.flow, this.capacity);
        }
    }

    public class VertexExtension
    extends MaximumFlowAlgorithmBase.VertexExtensionBase {
        private int label;

        private boolean hasExcess() {
            return this.excess > 0.0;
        }

        public String toString() {
            return this.prototype.toString() + String.format(" { LBL: %d } ", this.label);
        }
    }

    private class PushRelabelDiagnostic {
        Map<Pair<V, V>, Integer> discharges = new HashMap();
        long dischargesCounter = 0L;
        Map<Pair<Integer, Integer>, Integer> relabels = new HashMap<Pair<Integer, Integer>, Integer>();
        long relabelsCounter = 0L;

        private PushRelabelDiagnostic() {
        }

        private void incrementDischarges(EdgeExtension ex) {
            Pair p = Pair.of(ex.getSource().prototype, ex.getTarget().prototype);
            if (!this.discharges.containsKey(p)) {
                this.discharges.put(p, 0);
            }
            this.discharges.put(p, this.discharges.get(p) + 1);
            ++this.dischargesCounter;
        }

        private void incrementRelabels(int from, int to) {
            Pair<Integer, Integer> p = Pair.of(from, to);
            if (!this.relabels.containsKey(p)) {
                this.relabels.put(p, 0);
            }
            this.relabels.put(p, this.relabels.get(p) + 1);
            ++this.relabelsCounter;
        }

        void dump() {
            HashMap<Integer, Integer> labels = new HashMap<Integer, Integer>();
            for (Object v : PushRelabelMaximumFlow.this.network.vertexSet()) {
                VertexExtension vx = PushRelabelMaximumFlow.this.extendedVertex(v);
                if (!labels.containsKey(vx.label)) {
                    labels.put(vx.label, 0);
                }
                labels.put(vx.label, (Integer)labels.get(vx.label) + 1);
            }
            System.out.println("LABELS  ");
            System.out.println("------  ");
            System.out.println(labels);
            ArrayList<Map.Entry<Pair<Integer, Integer>, Integer>> relabelsSorted = new ArrayList<Map.Entry<Pair<Integer, Integer>, Integer>>(this.relabels.entrySet());
            Collections.sort(relabelsSorted, new Comparator<Map.Entry<Pair<Integer, Integer>, Integer>>(){

                @Override
                public int compare(Map.Entry<Pair<Integer, Integer>, Integer> o1, Map.Entry<Pair<Integer, Integer>, Integer> o2) {
                    return -(o1.getValue() - o2.getValue());
                }
            });
            System.out.println("RELABELS    ");
            System.out.println("--------    ");
            System.out.println("    Count:  " + this.relabelsCounter);
            System.out.println("            " + relabelsSorted);
            ArrayList dischargesSorted = new ArrayList(this.discharges.entrySet());
            Collections.sort(dischargesSorted, new Comparator<Map.Entry<Pair<V, V>, Integer>>(){

                @Override
                public int compare(Map.Entry<Pair<V, V>, Integer> one, Map.Entry<Pair<V, V>, Integer> other) {
                    return -(one.getValue() - other.getValue());
                }
            });
            System.out.println("DISCHARGES  ");
            System.out.println("----------  ");
            System.out.println("    Count:  " + this.dischargesCounter);
            System.out.println("            " + dischargesSorted);
        }
    }
}

