/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pocketknife.internal.customfields.service;

import com.atlassian.fugue.Option;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.context.IssueContextImpl;
import com.atlassian.jira.issue.context.manager.JiraContextTreeManager;
import com.atlassian.jira.issue.customfields.CustomFieldSearcher;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.customfields.option.Options;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.layout.field.EditableDefaultFieldLayout;
import com.atlassian.jira.issue.fields.layout.field.EditableFieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.customfields.service.CustomFieldException;
import com.atlassian.pocketknife.api.customfields.service.CustomFieldMetadata;
import com.atlassian.pocketknife.api.customfields.service.CustomFieldService;
import com.atlassian.pocketknife.api.customfields.service.FieldLockingService;
import com.atlassian.pocketknife.api.customfields.service.IssueTypeProvider;
import com.atlassian.pocketknife.internal.customfields.service.CustomFieldUtil;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.Validate;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomFieldServiceImpl
implements CustomFieldService {
    private static final Logger logger = LoggerFactory.getLogger(CustomFieldServiceImpl.class);
    private static final String GLOBAL_ISSUETYPE = "-1";
    @Autowired
    private CustomFieldManager customFieldManager;
    @Autowired
    private ConstantsManager constantsManager;
    @Autowired
    private I18nHelper.BeanFactory i18nFactoryService;
    @Autowired
    private ApplicationProperties applicationProperties;
    @Autowired
    private FieldLayoutManager fieldLayoutManager;
    @Autowired
    private FieldLockingService fieldLockingService;

    @Override
    public CustomField createCustomField(CustomFieldMetadata fieldMetadata) {
        logger.info("Create custom field {}", (Object)fieldMetadata);
        CustomField customField = null;
        try {
            I18nHelper i18n = this.i18nFactoryService.getInstance(this.applicationProperties.getDefaultLocale());
            String name = i18n.getText(fieldMetadata.getFieldName());
            String desc = i18n.getText(fieldMetadata.getFieldDescription());
            Option type = Option.option((Object)this.customFieldManager.getCustomFieldType(fieldMetadata.getFieldType()));
            Option searcher = Option.option((Object)this.customFieldManager.getCustomFieldSearcher(fieldMetadata.getFieldSearcher()));
            Set<String> issueTypeIds = this.getIssueTypeIds(fieldMetadata.getIssueTypeProvider());
            List<GenericValue> genericIssueTypeValues = this.convert(issueTypeIds);
            List contexts = CustomFieldUtils.buildJiraIssueContexts((boolean)true, null, null, (JiraContextTreeManager)this.getContextTreeManager());
            customField = this.customFieldManager.createCustomField(name, desc, (CustomFieldType)type.get(), (CustomFieldSearcher)searcher.getOrNull(), contexts, genericIssueTypeValues);
            if (!fieldMetadata.getOptionNames().isEmpty()) {
                for (String issueTypeId : issueTypeIds) {
                    Option<FieldConfig> fieldConfig = CustomFieldUtil.getRelevantConfig(customField, (IssueContext)new IssueContextImpl(null, issueTypeId));
                    this.addOptionsToCustomField(customField, fieldConfig, fieldMetadata.getOptionNames(), fieldMetadata.getDefaultOptionName());
                }
                this.setOptionsOrderFromMetadata(customField, fieldMetadata, issueTypeIds);
            }
            if (fieldMetadata.isRequireField()) {
                this.makeFieldRequired(customField);
            }
            if (fieldMetadata.isLockField()) {
                this.fieldLockingService.lockField(customField, fieldMetadata.getLockFieldDescription());
            }
            return customField;
        }
        catch (Exception ex) {
            logger.error("Failed to create custom field {} ", (Object)fieldMetadata, (Object)ex);
            if (customField != null) {
                try {
                    this.customFieldManager.removeCustomField(customField);
                }
                catch (Exception ignore) {
                    logger.warn("Exception when attempting to cleanup custom field {} ", customField, (Object)ignore);
                }
            }
            throw new CustomFieldException("Exception while trying to create a customField with the following parameters", ex);
        }
    }

    private Set<String> getIssueTypeIds(Option<IssueTypeProvider> issueTypeProvider) {
        HashSet<String> issueTypeIds = new HashSet<String>();
        if (issueTypeProvider.isDefined()) {
            for (IssueType issueType : ((IssueTypeProvider)issueTypeProvider.get()).getIssueTypes()) {
                issueTypeIds.add(issueType.getId());
            }
        }
        if (issueTypeIds.isEmpty()) {
            issueTypeIds.add(GLOBAL_ISSUETYPE);
        }
        return issueTypeIds;
    }

    private List<GenericValue> convert(Set<String> issueTypeIds) {
        HashSet<String> ids = new HashSet<String>();
        ids.addAll(issueTypeIds);
        List values = CustomFieldUtils.buildIssueTypes((ConstantsManager)this.constantsManager, (String[])ids.toArray(new String[ids.size()]));
        return values;
    }

    private JiraContextTreeManager getContextTreeManager() {
        return (JiraContextTreeManager)ComponentAccessor.getComponent(JiraContextTreeManager.class);
    }

    private void addOptionsToCustomField(CustomField customField, Option<FieldConfig> fieldConfigOption, List<String> optionNames, String defaultOptionName) {
        I18nHelper i18n = this.i18nFactoryService.getInstance(this.applicationProperties.getDefaultLocale());
        Option<Options> options = CustomFieldUtil.getCustomFieldOptions(customField, fieldConfigOption);
        if (options.isEmpty()) {
            return;
        }
        FieldConfig fieldConfig = (FieldConfig)fieldConfigOption.get();
        for (String optionName : optionNames) {
            String translatedOption = i18n.getText(optionName);
            com.atlassian.jira.issue.customfields.option.Option option = ((Options)options.get()).addOption(null, translatedOption);
            if (!optionName.equals(defaultOptionName)) continue;
            customField.getCustomFieldType().setDefaultValue(fieldConfig, (Object)option);
        }
    }

    private void setOptionsOrderFromMetadata(CustomField customField, CustomFieldMetadata fieldMetadata, Set<String> issueTypeIds) {
        List<String> optionValues = this.getOptionValuesFromNames(fieldMetadata.getOptionNames());
        for (String issueTypeId : issueTypeIds) {
            Option<FieldConfig> fieldConfig = CustomFieldUtil.getRelevantConfig(customField, (IssueContext)new IssueContextImpl(null, issueTypeId));
            if (fieldConfig.isEmpty()) {
                logger.warn("Could not find a Custom Field Configuration for field {}, all projects and issue type {} -- therefore cannot find the Options for the field.", (Object)customField.getId(), (Object)issueTypeId);
                continue;
            }
            Option<Options> optionsResult = CustomFieldUtil.getCustomFieldOptions(customField, fieldConfig);
            if (optionsResult.isEmpty()) continue;
            Options options = (Options)optionsResult.get();
            HashMap<Integer, com.atlassian.jira.issue.customfields.option.Option> optionToPositionMap = new HashMap<Integer, com.atlassian.jira.issue.customfields.option.Option>(options.size());
            List rootOptions = options.getRootOptions();
            if (optionValues.size() != options.size()) {
                throw new CustomFieldException("When setting custom field options order, available options must match initially created options");
            }
            for (com.atlassian.jira.issue.customfields.option.Option option : rootOptions) {
                if (!optionValues.contains(option.getValue())) {
                    throw new CustomFieldException("When setting custom field options order, available options must match initially created options");
                }
                optionToPositionMap.put(optionValues.indexOf(option.getValue()), option);
            }
            options.moveOptionToPosition(optionToPositionMap);
        }
    }

    private List<String> getOptionValuesFromNames(List<String> optionNames) {
        final I18nHelper i18n = this.i18nFactoryService.getInstance(this.applicationProperties.getDefaultLocale());
        return Lists.transform(optionNames, (Function)new Function<String, String>(){

            public String apply(@Nullable String optionName) {
                return i18n.getText(optionName);
            }
        });
    }

    private void makeFieldRequired(CustomField field) {
        List layouts = this.fieldLayoutManager.getEditableFieldLayouts();
        for (EditableFieldLayout layout : layouts) {
            FieldLayoutItem fieldLayoutItem = layout.getFieldLayoutItem(field.getId());
            if (fieldLayoutItem == null) continue;
            layout.makeRequired(fieldLayoutItem);
            if (layout.isDefault()) {
                this.fieldLayoutManager.storeEditableDefaultFieldLayout((EditableDefaultFieldLayout)layout);
                continue;
            }
            this.fieldLayoutManager.storeEditableFieldLayout(layout);
        }
    }

    @Override
    public CustomField getCustomField(Long id) {
        logger.info("Retrieve custom field {}", (Object)id);
        return this.customFieldManager.getCustomFieldObject(id);
    }

    @Override
    public CustomField getCustomField(String id) {
        logger.info("Retrieve custom field {}", (Object)id);
        return this.customFieldManager.getCustomFieldObject(id);
    }

    @Override
    public void removeCustomField(CustomField customField) {
        logger.info("Remove custom field {}", (Object)customField);
        try {
            this.customFieldManager.removeCustomField(customField);
        }
        catch (RemoveException e) {
            logger.info("Remove custom field {}", (Object)customField, (Object)e);
            throw new CustomFieldException(e);
        }
    }

    @Override
    public <T extends CustomFieldType> List<CustomField> getCustomFields(Class<T> type) {
        logger.info("Retrieve custom field {}", type);
        return this.getCustomFields(type, true);
    }

    @Override
    public <T extends CustomFieldType> List<CustomField> getCustomFields(Class<T> type, boolean strict) {
        logger.info("Retrieve custom field {}", type);
        Validate.notNull(type, (String)"The Class for the CustomFieldType cannot be null");
        ArrayList<CustomField> fields = new ArrayList<CustomField>();
        for (CustomField customField : this.customFieldManager.getCustomFieldObjects()) {
            if (strict && customField.getCustomFieldType().getClass().equals(type)) {
                fields.add(customField);
                continue;
            }
            if (strict || !type.isAssignableFrom(customField.getCustomFieldType().getClass())) continue;
            fields.add(customField);
        }
        return fields;
    }
}

