/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.actset;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.calculation.CancellationState;
import com.atlassian.rm.jpo.scheduling.instrumentation.SolverMetrics;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.actset.AbstractActivitySetScheduler;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.actset.ActivitySetScheduleEvaluation;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.actset.GroupActivitySetScheduler;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.actset.IActivitySetResourcePoolScheduler;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.actset.IActivitySetScheduleEvaluation;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.actset.IActivitySetSchedulingProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.actset.IEnforcedActivitySetScheduler;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.actset.TimeLimitedTerminationCondition;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.ItemNotSchedulableException;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.ReachedPlanningHorizonException;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IActivitySetSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.util.RmSchedulingUtils;
import com.atlassian.rm.jpo.scheduling.util.LogUtil;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;

public class EnforcedActivitySetScheduler
extends AbstractActivitySetScheduler
implements IEnforcedActivitySetScheduler {
    private static final Log LOGGER = Log.with(EnforcedActivitySetScheduler.class);

    EnforcedActivitySetScheduler(IActivitySetResourcePoolScheduler activitySetResourcePoolScheduler, IActivitySetScheduleEvaluation activitySetScheduleEvaluation, SolverMetrics metrics) {
        super(activitySetResourcePoolScheduler, activitySetScheduleEvaluation, metrics);
    }

    public EnforcedActivitySetScheduler(int maxTestAssignmentsPerTeamStage, CancellationState cancellationState, SolverMetrics metrics) {
        this(new GroupActivitySetScheduler(maxTestAssignmentsPerTeamStage, cancellationState), new ActivitySetScheduleEvaluation(), metrics);
    }

    @Override
    public IActivitySetSchedule scheduleActivitySet(IActivitySetSchedulingProblem problem) throws ItemNotSchedulableException, ReachedPlanningHorizonException, InterruptedException {
        Preconditions.checkNotNull((Object)problem, (Object)"problem must not be null");
        LogUtil.debug(LOGGER, "schedule activity set: %s", problem);
        TimeLimitedTerminationCondition terminationCondition = new TimeLimitedTerminationCondition(problem.getUpperTimeBound());
        Optional<IActivitySetSchedule> activitySetSchedule = this.scheduleActivitySet(problem, terminationCondition);
        if (!activitySetSchedule.isPresent()) {
            if (problem.isUpperTimeBoundPlanningHorizon() && RmSchedulingUtils.hasUnlimitedResource(problem.getMutableResourcePools())) {
                throw new ReachedPlanningHorizonException(problem.getId());
            }
            throw new ItemNotSchedulableException(problem.getId(), null);
        }
        return (IActivitySetSchedule)activitySetSchedule.get();
    }
}

