/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.jira.lifecycle;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.common.bridges.api.SupportedVersions;
import com.atlassian.rm.common.bridges.api.SupportedVersionsUtils;
import com.atlassian.rm.common.bridges.jira.JiraVersionAccessor;
import com.atlassian.rm.common.bridges.jira.lifecycle.PluginLifeCycleTask;
import com.google.common.base.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.jira.lifecycle.JiraVersionAwareLifecycleTaskGuavaPredicate")
class JiraVersionAwareLifecycleTaskGuavaPredicate
implements Predicate<PluginLifeCycleTask> {
    private static final Log LOGGER = Log.with(JiraVersionAwareLifecycleTaskGuavaPredicate.class);
    private final JiraVersionAccessor jiraVersionAccessor;

    @Autowired
    public JiraVersionAwareLifecycleTaskGuavaPredicate(JiraVersionAccessor jiraVersionAccessor) {
        this.jiraVersionAccessor = jiraVersionAccessor;
    }

    public boolean apply(PluginLifeCycleTask task) {
        LOGGER.debug("check if task is supported: %s", task.getDisplayName());
        for (SupportedVersions supportedVersions : SupportedVersionsUtils.getAllSupportedVersions(task)) {
            if (!this.jiraVersionAccessor.getVersion().isSupported(supportedVersions)) continue;
            LOGGER.debug("task is supported: %s", task.getDisplayName());
            return true;
        }
        LOGGER.debug("task is not supported: %s", task.getDisplayName());
        return false;
    }
}

