/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.entities.workitems;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.entities.workitems.IEstimate;
import com.radiantminds.roadmap.common.data.entities.workitems.IEstimateBlock;
import com.radiantminds.roadmap.common.rest.entities.workitems.RestEstimate;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="estimateBlock")
@XmlAccessorType(value=XmlAccessType.NONE)
public class RestEstimateBlock
implements IEstimateBlock {
    @XmlElement
    private RestEstimate total;
    @XmlElement
    private List<RestEstimate> skills = Lists.newArrayList();
    @XmlElement
    private List<RestEstimate> stages = Lists.newArrayList();

    @Override
    public Optional<IEstimate> getTotal() {
        return Optional.fromNullable((Object)this.total);
    }

    public void setTotal(IEstimate total) {
        this.total = (RestEstimate)total;
    }

    @Override
    public List<IEstimate> getSkills() {
        if (this.skills != null) {
            return Lists.newArrayList(this.skills);
        }
        return Lists.newArrayList();
    }

    @Override
    public void setSkills(List<IEstimate> skills) {
        this.skills = Lists.newArrayList();
        for (IEstimate skill : skills) {
            this.skills.add((RestEstimate)skill);
        }
    }

    @Override
    public Double sum() {
        Double sum = 0.0;
        if (this.total != null && this.total.getEstimate() != null) {
            sum = sum + this.total.getEstimate();
        }
        if (this.skills != null) {
            for (RestEstimate e : this.skills) {
                if (e.getEstimate() == null) continue;
                sum = sum + e.getEstimate();
            }
        }
        if (this.stages != null) {
            for (RestEstimate e : this.stages) {
                if (e.getEstimate() == null) continue;
                sum = sum + e.getEstimate();
            }
        }
        return sum;
    }

    @Override
    public List<IEstimate> getStages() {
        if (this.stages != null) {
            return Lists.newArrayList(this.stages);
        }
        return Lists.newArrayList();
    }

    @Override
    public void setStages(List<IEstimate> stages) {
        this.stages = Lists.newArrayList();
        for (IEstimate stage : stages) {
            this.stages.add((RestEstimate)stage);
        }
    }

    @Override
    public Optional<IEstimate> getEstimateForSkill(String id) {
        for (IEstimate iEstimate : this.skills) {
            if (!iEstimate.getTargetId().toString().equals(id)) continue;
            return Optional.fromNullable((Object)iEstimate);
        }
        return Optional.absent();
    }

    @Override
    public Optional<IEstimate> getEstimateForStage(String id) {
        for (IEstimate iEstimate : this.stages) {
            if (!iEstimate.getTargetId().toString().equals(id)) continue;
            return Optional.fromNullable((Object)iEstimate);
        }
        return Optional.absent();
    }

    @Override
    public void addStageEstimate(RestEstimate estimate) {
        if (this.stages == null) {
            this.stages = Lists.newArrayList();
        }
        this.stages.add(estimate);
    }

    @Override
    public void addSkillEstimate(RestEstimate estimate) {
        if (this.skills == null) {
            this.skills = Lists.newArrayList();
        }
        this.skills.add(estimate);
    }

    @Override
    public void setTotal(RestEstimate estimate) {
        this.total = estimate;
    }
}

