/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.kit.datecalc.joda;

import net.objectlab.kit.datecalc.common.AbstractKitCalculatorsFactory;
import net.objectlab.kit.datecalc.common.DateCalculator;
import net.objectlab.kit.datecalc.common.IMMDateCalculator;
import net.objectlab.kit.datecalc.common.KitCalculatorsFactory;
import net.objectlab.kit.datecalc.common.PeriodCountCalculator;
import net.objectlab.kit.datecalc.joda.YearMonthDayBackwardHandler;
import net.objectlab.kit.datecalc.joda.YearMonthDayDateCalculator;
import net.objectlab.kit.datecalc.joda.YearMonthDayForwardHandler;
import net.objectlab.kit.datecalc.joda.YearMonthDayForwardUnlessNegativeHandler;
import net.objectlab.kit.datecalc.joda.YearMonthDayIMMDateCalculator;
import net.objectlab.kit.datecalc.joda.YearMonthDayModifiedFollowingHandler;
import net.objectlab.kit.datecalc.joda.YearMonthDayModifiedPrecedingHandler;
import net.objectlab.kit.datecalc.joda.YearMonthDayPeriodCountCalculator;
import org.joda.time.YearMonthDay;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YearMonthDayKitCalculatorsFactory
extends AbstractKitCalculatorsFactory<YearMonthDay> {
    private static final KitCalculatorsFactory<YearMonthDay> DEFAULT = new YearMonthDayKitCalculatorsFactory();
    private static final PeriodCountCalculator<YearMonthDay> PCC = new YearMonthDayPeriodCountCalculator();
    private static final IMMDateCalculator<YearMonthDay> IMMDC = new YearMonthDayIMMDateCalculator();

    public static KitCalculatorsFactory<YearMonthDay> getDefaultInstance() {
        return DEFAULT;
    }

    @Override
    public DateCalculator<YearMonthDay> getDateCalculator(String name, String holidayHandlerType) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null, use anything.");
        }
        YearMonthDayDateCalculator cal = new YearMonthDayDateCalculator();
        cal.setName(name);
        this.setHolidays(name, cal);
        if ("forward".equals(holidayHandlerType)) {
            cal.setHolidayHandler(new YearMonthDayForwardHandler());
        } else if ("backward".equals(holidayHandlerType)) {
            cal.setHolidayHandler(new YearMonthDayBackwardHandler());
        } else if ("modifiedFollowing".equals(holidayHandlerType)) {
            cal.setHolidayHandler(new YearMonthDayModifiedFollowingHandler());
        } else if ("modifiedPreceding".equals(holidayHandlerType)) {
            cal.setHolidayHandler(new YearMonthDayModifiedPrecedingHandler());
        } else if ("forwardUnlessMovingBack".equals(holidayHandlerType)) {
            cal.setHolidayHandler(new YearMonthDayForwardUnlessNegativeHandler());
        } else if (holidayHandlerType != null) {
            throw new IllegalArgumentException("Unsupported HolidayHandler: " + holidayHandlerType);
        }
        return cal;
    }

    @Override
    public PeriodCountCalculator<YearMonthDay> getPeriodCountCalculator() {
        return PCC;
    }

    @Override
    public IMMDateCalculator<YearMonthDay> getIMMDateCalculator() {
        return IMMDC;
    }
}

