/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pocketknife.api.logging;

import org.apache.log4j.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Log {
    private final Logger logger;

    Log(Logger logger) {
        this.logger = logger;
    }

    public static Log with(Logger logger) {
        return new Log(logger);
    }

    public static Log with(Class clazz) {
        return Log.with(LoggerFactory.getLogger((Class)clazz));
    }

    public static Log with(String name) {
        return Log.with(LoggerFactory.getLogger((String)name));
    }

    public String getName() {
        return this.logger.getName();
    }

    public void setInfoLogLevel() {
        org.apache.log4j.Logger.getLogger((String)this.logger.getName()).setLevel(Level.INFO);
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public void exception(Throwable t) {
        this.exception(t, LogLevel.ERROR);
    }

    public void exception(Throwable t, LogLevel logLevel) {
        try {
            switch (logLevel) {
                case ERROR: {
                    this.logger.error(t.getLocalizedMessage(), t);
                    break;
                }
                case DEBUG: {
                    this.logger.debug(t.getLocalizedMessage(), t);
                    break;
                }
                case WARN: {
                    this.logger.warn(t.getLocalizedMessage(), t);
                    break;
                }
                case INFO: {
                    this.logger.info(t.getLocalizedMessage(), t);
                    break;
                }
                case TRACE: {
                    this.logger.trace(t.getLocalizedMessage(), t);
                }
            }
        }
        catch (Throwable t1) {
            t.printStackTrace();
            t1.printStackTrace();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
    }

    public void error(String message, Object ... params) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(this.createMessage(message, params));
        }
    }

    public void warn(String message, Object ... params) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn(this.createMessage(message, params));
        }
    }

    public void info(String message, Object ... params) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(this.createMessage(message, params));
        }
    }

    public void debug(String message, Object ... params) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.createMessage(message, params));
        }
    }

    public void trace(String message, Object ... params) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(this.createMessage(message, params));
        }
    }

    public void warnDebug(Exception e, String message, Object ... params) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn(this.createMessage(message, params));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.createMessage(message, params), (Throwable)e);
        }
    }

    public void errorDebug(Exception e, String message, Object ... params) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(this.createMessage(message, params));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.createMessage(message, params), (Throwable)e);
        }
    }

    public String createMessage(String message, Object[] params) {
        try {
            return String.format(message, params);
        }
        catch (RuntimeException e) {
            this.logger.error("Unable to format message: " + message, (Throwable)e);
            return "";
        }
    }

    public static enum LogLevel {
        ERROR,
        WARN,
        DEBUG,
        INFO,
        TRACE;

    }
}

